/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.es.builder.search;

import com.ohaotian.plugin.es.builder.Builder;
import com.ohaotian.plugin.es.builder.search.FilterBuilder;
import java.util.LinkedList;
import java.util.List;

public class AggregateBuilder
implements Builder<List<AggregateColumn>> {
    private List<AggregateColumn> aggColumn = new LinkedList<AggregateColumn>();

    private AggregateBuilder() {
    }

    public static AggregateBuilder newBuilder() {
        return new AggregateBuilder();
    }

    public AggregateColumn setGroupId(String columnName) {
        AggregateColumn aggregateColumn = new AggregateColumn(columnName, false);
        this.aggColumn.add(aggregateColumn);
        return aggregateColumn;
    }

    public AggregateColumn setNestedColName(String columnName) {
        AggregateColumn aggregateColumn = new AggregateColumn(columnName, true);
        this.aggColumn.add(aggregateColumn);
        return aggregateColumn;
    }

    @Override
    public List<AggregateColumn> build() {
        return this.aggColumn;
    }

    public static enum FuncName {
        SUM,
        MAX,
        MIN,
        COUNT;

    }

    public class AggregateFunction {
        private final String columnName;
        private final FuncName funcName;

        public AggregateFunction(String columnName, FuncName funcName) {
            this.columnName = columnName;
            this.funcName = funcName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public FuncName getFuncName() {
            return this.funcName;
        }
    }

    public class AggregateColumn {
        private final String name;
        private final boolean isNested;
        private final List<AggregateFunction> functions;
        private FilterBuilder filterBuilder;

        public AggregateColumn(String name, boolean isNested) {
            this.name = name;
            this.isNested = isNested;
            this.functions = new LinkedList<AggregateFunction>();
        }

        public FilterBuilder filterBuilder() {
            if (this.filterBuilder == null) {
                this.filterBuilder = FilterBuilder.newBuilder();
            }
            return this.filterBuilder;
        }

        public String getName() {
            return this.name;
        }

        public boolean isNested() {
            return this.isNested;
        }

        public List<AggregateFunction> getFunctions() {
            return this.functions;
        }

        public AggregateColumn max(String columnName) {
            AggregateFunction function = new AggregateFunction(columnName, FuncName.MAX);
            this.functions.add(function);
            return this;
        }

        public AggregateColumn min(String columnName) {
            AggregateFunction function = new AggregateFunction(columnName, FuncName.MIN);
            this.functions.add(function);
            return this;
        }

        public AggregateColumn sum(String columnName) {
            AggregateFunction function = new AggregateFunction(columnName, FuncName.SUM);
            this.functions.add(function);
            return this;
        }

        public AggregateColumn count() {
            AggregateFunction function = new AggregateFunction(null, FuncName.COUNT);
            this.functions.add(function);
            return this;
        }
    }
}

