package com.ohaotian.plugin.es.annotation;

import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author pengys5
 */
@Component
public class DaoInjector {

    private final Logger logger = LogManager.getLogger(DaoInjector.class);

    @Autowired
    private DaoAutowiredBeanContainer container;

    public void inject(DBType dbType) {
        for (DaoAutowiredBeanContainer.DaoAutowiredBean autowiredBean : container.getBeans()) {
            Object bean = autowiredBean.getBean();
            Field field = autowiredBean.getDaoField();

            if (!field.isAccessible()) {
                field.setAccessible(true);
            }

            String interfaceName = field.getType().getName();
            Object value = container.getFactoryMap().get(interfaceName).generate(field.getType(), dbType);

            try {
                if (value != null) {
                    field.set(bean, value);
                }
            } catch (Throwable e) {
                logger.error("DAO自动装载失败，属性名:", field.getName() + ",所属类名:" + bean.getClass().getName() + ", 错误信息: " + e.getMessage(), e);
            }
        }
    }

    public enum DBType {
        ElasticSearch, OpenSearch
    }
}
