package com.ohaotian.plugin.es.builder.batch;

import com.ohaotian.plugin.es.annotation.DaoInjector;
import com.ohaotian.plugin.es.builder.Adapter;
import com.ohaotian.plugin.es.elasticsearch.builder.batch.EsBatchInsertRequestBuilder;
import com.ohaotian.plugin.es.opensearch.builder.batch.OsBatchInsertRequestBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author pengys5
 */
@Component
public class BatchInsertRequestBuilderAdapter implements Adapter<BatchInsertRequestBuilder> {

    private DaoInjector.DBType dbType;

    @Autowired
    private OsBatchInsertRequestBuilder osBatchInsertRequestBuilder;

    //@Autowired
    private EsBatchInsertRequestBuilder esBatchInsertRequestBuilder;

    @Override public void setDBType(DaoInjector.DBType dbType) {
        this.dbType = dbType;
    }

    @Override public BatchInsertRequestBuilder requestBuilder() {
        if (DaoInjector.DBType.ElasticSearch.equals(dbType)) {
            return esBatchInsertRequestBuilder;
        } else if (DaoInjector.DBType.OpenSearch.equals(dbType)) {
            return osBatchInsertRequestBuilder;
        } else {
            throw new RuntimeException("启动的数据库类型未找到，请检查数据库配置");
        }
    }
}
