package com.ohaotian.plugin.es.builder.insert;

import com.ohaotian.plugin.es.annotation.DaoInjector;
import com.ohaotian.plugin.es.builder.Adapter;
import com.ohaotian.plugin.es.elasticsearch.builder.insert.EsInsertRequestBuilder;
import com.ohaotian.plugin.es.opensearch.builder.insert.OsInsertRequestBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author pengys5
 */
@Component
public class InsertRequestBuilderAdapter implements Adapter<InsertRequestBuilder> {

    private DaoInjector.DBType dbType;

    @Autowired
    private OsInsertRequestBuilder osInsertRequestBuilder;

    @Autowired
    private EsInsertRequestBuilder esInsertRequestBuilder;

    @Override public InsertRequestBuilder requestBuilder() {
        if (DaoInjector.DBType.ElasticSearch.equals(dbType)) {
            return esInsertRequestBuilder;
        } else if (DaoInjector.DBType.OpenSearch.equals(dbType)) {
            return osInsertRequestBuilder;
        } else {
            throw new RuntimeException("启动的数据库类型未找到，请检查数据库配置");
        }
    }

    @Override public void setDBType(DaoInjector.DBType dbType) {
        this.dbType = dbType;
    }
}
