package com.ohaotian.plugin.es.opensearch;

import com.ohaotian.plugin.es.core.ConfigCheck;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * @author pengys5
 */
@Component
public class OpenSearchConfigCheck implements ConfigCheck {

    private final Logger logger = LogManager.getLogger(OpenSearchConfigCheck.class);

    @Autowired
    private OpenSearchConfig config;

    @Override public boolean check() {
        logger.info("open search config, host: {}", config.getHost());

        Boolean isOk = false;
        if (!StringUtils.isEmpty(config.getHost()) && !StringUtils.isEmpty(config.getAccesskey()) && !StringUtils.isEmpty(config.getSecret())) {
            isOk = true;
        }
        return isOk;
    }
}
