package com.ohaotian.plugin.es.opensearch.builder.batch;

import com.aliyun.opensearch.DocumentClient;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.ohaotian.plugin.es.builder.batch.BatchDeleteRequestBuilder;
import com.ohaotian.plugin.es.opensearch.OpenSearchClient;
import com.ohaotian.plugin.es.opensearch.builder.delete.OsDeleteRequestBuilder;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author yudg
 */
@Component
public class OsBatchDeleteRequestBuilder implements BatchDeleteRequestBuilder<OsDeleteRequestBuilder.OsDeleteBuilderItem> {

    private final Logger logger = LogManager.getLogger(OsBatchDeleteRequestBuilder.class);

    @Autowired
    private OpenSearchClient client;

    @Override public void bulk(Collection<OsDeleteRequestBuilder.OsDeleteBuilderItem> builders) {
        DocumentClient documentClient = this.client.createDocumentClient();
        JSONArray rows = new JSONArray();
        String tableName = "";
        for (OsDeleteRequestBuilder.OsDeleteBuilderItem builderItem : builders) {
            for (int i = 0; i < builderItem.getRows().length(); i++) {
                rows.put(builderItem.getRows().get(i));
                tableName = builderItem.getTableName();
            }
        }
        try {
        	logger.info("delete cmd=="+rows);
            documentClient.push(rows.toString(), tableName, tableName);
        } catch (OpenSearchException | OpenSearchClientException e) {
            logger.error(e.getMessage(), e);
        }
    }
}
