package com.ohaotian.plugin.es.opensearch.builder.batch;

import com.aliyun.opensearch.DocumentClient;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.ohaotian.plugin.es.builder.batch.BatchUpdateRequestBuilder;
import com.ohaotian.plugin.es.opensearch.OpenSearchClient;
import com.ohaotian.plugin.es.opensearch.builder.update.OsUpdateRequestBuilder;

import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/** <br>
 * 标题: <br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho yudg
 * @time 2017年9月22日 下午11:05:06 */
@Component
public class OsBatchUpdateRequestBuilder implements BatchUpdateRequestBuilder<OsUpdateRequestBuilder.OsUpdateBuilderItem> {

	private final Logger	 logger	= LogManager.getLogger(OsBatchUpdateRequestBuilder.class);

	@Autowired
	private OpenSearchClient client;

	@Override
	public void bulk(Collection<OsUpdateRequestBuilder.OsUpdateBuilderItem> builders) {
		DocumentClient documentClient = this.client.createDocumentClient();
		JSONArray rows = new JSONArray();
		String tableName = "";
		for (OsUpdateRequestBuilder.OsUpdateBuilderItem builderItem : builders) {
			for (int i = 0; i < builderItem.getRows().length(); i++) {
				rows.put(builderItem.getRows().get(i));
				tableName = builderItem.getTableName();
			}
		}
		try {
			logger.info("update cmd==" + rows);
			documentClient.push(rows.toString(), tableName, tableName);
		}
		catch (OpenSearchException | OpenSearchClientException e) {
			logger.error(e.getMessage(), e);
		}
	}
}
