package com.ohaotian.plugin.es.opensearch.builder.delete;

import com.aliyun.opensearch.DocumentClient;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchResult;
import com.aliyun.opensearch.sdk.generated.document.Command;
import com.aliyun.opensearch.sdk.generated.document.DocumentConstants;
import com.ohaotian.plugin.es.builder.delete.DeleteBuilderItem;
import com.ohaotian.plugin.es.builder.delete.DeleteRequestBuilder;
import com.ohaotian.plugin.es.builder.insert.ColumnValueBuilder;
import com.ohaotian.plugin.es.builder.schema.DataType;
import com.ohaotian.plugin.es.builder.schema.Field;
import com.ohaotian.plugin.es.builder.schema.Nested;
import com.ohaotian.plugin.es.opensearch.OpenSearchClient;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author pengys5
 */
@Component
public class OsDeleteRequestBuilder implements DeleteRequestBuilder<OsDeleteRequestBuilder.OsDeleteBuilderItem> {

    private final Logger logger = LogManager.getLogger(OsDeleteRequestBuilder.class);

    @Autowired
    private OpenSearchClient client;

    @Override
	public OsDeleteBuilderItem build(String tableName, String id, ColumnValueBuilder columnValueBuilder) {
    	JSONArray rows = new JSONArray();
        JSONObject row = new JSONObject();
        row.put(DocumentConstants.DOC_KEY_CMD, Command.DELETE.toString());
        rows.put(row);

        JSONObject doc = new JSONObject();
        row.put(DocumentConstants.DOC_KEY_FIELDS, doc);

        List<Field> fields = columnValueBuilder.build();
        for (Field field : fields) {
            if (DataType.Double.equals(field.getDateType()) || DataType.Integer.equals(field.getDateType()) || DataType.Long.equals(field.getDateType())) {
                doc.put(field.getName(), field.getValue());
            } else if (DataType.Text.equals(field.getDateType())) {
                doc.put(field.getName(), field.getValue());
            } else if (DataType.Nested.equals(field.getDateType())) {
                Nested nested = (Nested)field.getValue();
                JSONArray nestedArray = new JSONArray();
                for (String nestedRow : nested.getRows()) {
                    nestedArray.put(nestedRow);
                }
                doc.put(field.getName(), nestedArray);
            }else  if (DataType.List.equals(field.getDateType())) {
            	List<String> values =(List<String>)field.getValue();
            	JSONArray rows1 = new JSONArray();
            	for(String s:values){
            		JSONObject doc1 = new JSONObject();
            		JSONObject row1 = new JSONObject();
                    row1.put(DocumentConstants.DOC_KEY_CMD, Command.DELETE.toString());
                    row1.put(DocumentConstants.DOC_KEY_FIELDS, doc1);
                    rows1.put(row1);
                    doc1.put(field.getName(), s);
            	}
            	rows=rows1;
            }
        }
        return new OsDeleteBuilderItem(tableName, rows, client);
	}
    
    public class OsDeleteBuilderItem implements DeleteBuilderItem {
        private final String tableName;
        private final JSONArray rows;
        private final OpenSearchClient client;

        public OsDeleteBuilderItem(String tableName, JSONArray rows, OpenSearchClient client) {
            this.tableName = tableName;
            this.rows = rows;
            this.client = client;
        }

        public String get() {
            try {
                DocumentClient documentClient = this.client.createDocumentClient();
                OpenSearchResult result = documentClient.push(rows.toString(), tableName, tableName);
                return result.getResult();
            } catch (OpenSearchException | OpenSearchClientException e) {
                logger.error(e.getMessage(), e);
            }
            return null;
        }

        public String getTableName() {
            return tableName;
        }

        public JSONArray getRows() {
            return rows;
        }
    }
}
