package com.ohaotian.plugin.es.opensearch.builder.search;

import com.ohaotian.plugin.es.builder.search.query.BooleanQueryCondition;
import com.ohaotian.plugin.es.builder.search.query.MatchQueryCondition;
import com.ohaotian.plugin.es.builder.search.query.QueryCondition;

/**
 * @author pengys5
 */
public enum OpenSearchQueryBuilder {
    INSTANCE;

    public String build(QueryCondition condition) {
        if (condition instanceof MatchQueryCondition) {
            MatchQueryCondition matchCondition = (MatchQueryCondition)condition;
            return matchCondition.getColumnName() + ":" + matchCondition.getValue();
        } else if (condition instanceof BooleanQueryCondition) {
            BooleanQueryCondition booleanCondition = (BooleanQueryCondition)condition;

            StringBuilder boolConditionStr = new StringBuilder();
            boolConditionStr.append("(");

            if (booleanCondition.getMust().size() > 0) {
                boolConditionStr.append("(");
                boolean firstMust = true;
                for (QueryCondition queryCondition : booleanCondition.getMust()) {
                    if (!firstMust) {
                        boolConditionStr.append(" AND ");
                    }
                    boolConditionStr.append(build(queryCondition));
                    firstMust = false;
                }
                boolConditionStr.append(")");
            }

            if (booleanCondition.getShould().size() > 0) {
                if (booleanCondition.getMust().size() > 0) {
                    boolConditionStr.append(" OR ");
                }

                boolConditionStr.append("(");
                boolean firstShould = true;
                for (QueryCondition queryCondition : booleanCondition.getShould()) {
                    if (!firstShould) {
                        boolConditionStr.append(" OR ");
                    }
                    boolConditionStr.append(build(queryCondition));
                    firstShould = false;
                }
                boolConditionStr.append(")");
            }

            boolConditionStr.append(")");

            return boolConditionStr.toString();
        } else {
            throw new RuntimeException("理论上不应该啊");
        }
    }
}