/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.fastdfs;

import com.ohaotian.plugin.file.AbstractFileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.fastdfs.FastdfsConfig;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.ohaotian.plugin.file.fastdfs.FastdfsUtil;
import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastdfsFileClient
extends AbstractFileClient {
    private static final Logger logger = LoggerFactory.getLogger(FastdfsFileClient.class);
    private FastdfsConfig fastdfsConfig;

    public FastdfsFileClient(FastdfsConfig fastdfsConfig) {
        this.fastdfsConfig = fastdfsConfig;
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream) {
        FastdfsFileInfo fileInfo = FastdfsUtil.uploadFile(fileName, this.fastdfsConfig, inputStream, uploadFilePath);
        logger.debug("plugin-file: Upload File Success Result [{}]", (Object)FastdfsFileInfo.toFilePath(fileInfo));
        return FastdfsFileInfo.toFilePath(fileInfo);
    }

    @Override
    public File downloadToFile(String filePath) {
        return FastdfsUtil.downloadFile(FastdfsFileInfo.toFastdfsFileInfo(filePath), this.fastdfsConfig);
    }

    @Override
    public InputStream downLoadToInputStream(String filePath) {
        return FastdfsUtil.downloadByInputStream(FastdfsFileInfo.toFastdfsFileInfo(filePath), this.fastdfsConfig);
    }

    @Override
    protected FileType getFileType() {
        return FileType.FASTDFS;
    }
}

