package com.ohaotian.plugin.file.util;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;

public class SessionChannelUtil {
	Session session = null;
	ChannelSftp channelSftp = null;
	ChannelExec channelExec = null;

	public Session sessionConnect(String username, String host, int port,
			String password, int timeout) throws JSchException {

		JSch jsch = new JSch();
		if (port <= 0) {
			session = jsch.getSession(username, host);
		} else {
			session = jsch.getSession(username, host, port);
		}
		session.setPassword(password);
		session.setConfig("StrictHostKeyChecking", "no");
//		session.setTimeout(timeout);
		session.connect();

		return session;
	}

	public ChannelSftp channelSftpConnect(Session session, int timeout)
			throws JSchException {

		channelSftp = (ChannelSftp) session.openChannel("sftp");
		channelSftp.connect(timeout);

		return channelSftp;
	}

	public ChannelExec channelExecConnect(Session session, String command,
			int timeout) throws JSchException {

		channelExec = (ChannelExec) session.openChannel("exec");
		channelExec.setCommand(command);
		channelExec.setInputStream(null);
		channelExec.connect(timeout);

		return channelExec;
	}

	public void closeSession() {

		if (channelSftp != null) {
			channelSftp.disconnect();
		}
		if (channelExec != null) {
			channelExec.disconnect();
		}
		if (session != null) {
			session.disconnect();
		}
	}

	public void closeChannelSftp() {

		if (channelSftp != null) {
			channelSftp.disconnect();
		}
	}

	public void closeChannelExec() {

		if (channelExec != null) {
			channelExec.disconnect();
		}

	}

}
