/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.fastdfs;

import com.github.tobato.fastdfs.domain.fdfs.StorePath;
import com.github.tobato.fastdfs.exception.FdfsUnsupportStorePathException;
import com.github.tobato.fastdfs.service.FastFileStorageClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsConfig;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class FastdfsUtil {
    private static final Logger logger = LoggerFactory.getLogger(FastdfsUtil.class);
    private static FastFileStorageClient storageClient;

    public static void setStorageClient(FastFileStorageClient client) {
        storageClient = client;
    }

    public static FastdfsFileInfo uploadFile(String fileName, FastdfsConfig config, InputStream fis, String uploadPath) {
        logger.info("plugin-file: Upload file to FastDFS File Name [{}]", (Object)fileName);
        long startTime = System.currentTimeMillis();
        try {
            String fileExtName = FastdfsUtil.getExtByFileName(fileName);
            StorePath storePath = storageClient.uploadFile(fis, (long)fis.available(), fileExtName, null);
            logger.info("plugin-file: upload_file time used:" + (System.currentTimeMillis() - startTime) + " ms");
            logger.info("plugin-file: upload file successfully!!!group_name:" + storePath.getGroup() + ", remoteFileName:" + storePath.getPath());
            return new FastdfsFileInfo(storePath.getGroup(), storePath.getPath());
        }
        catch (IOException e) {
            logger.error("plugin-file: IO Exception when uploading the file:" + fileName, (Throwable)e);
        }
        catch (Exception e) {
            logger.error("plugin-file: Exception when uploading the file:" + fileName, (Throwable)e);
        }
        return new FastdfsFileInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(FastdfsFileInfo fastdfsFileInfo, FastdfsConfig config) {
        String dir = System.getProperty("java.io.tmpdir");
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        String fileName = dir + "/" + fastdfsFileInfo.getFileName();
        logger.debug("plugin-file: Download FastDFS File To Tmpdir File Name [{}]", (Object)fileName);
        InputStream inputStream = FastdfsUtil.downloadByInputStream(fastdfsFileInfo, config);
        if (inputStream == null) {
            return null;
        }
        File file = new File(fileName);
        File parentDir = new File(file.getParent());
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            int len;
            byte[] b = new byte[1024];
            while ((len = inputStream.read(b)) != -1) {
                fos.write(b, 0, len);
            }
        }
        catch (Exception e) {
            logger.error("plugin-file: Download FastDFS File Error: " + e.getMessage(), (Throwable)e);
            File file2 = null;
            return file2;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static InputStream downloadByInputStream(FastdfsFileInfo fastdfsFileInfo, FastdfsConfig config) {
        try {
            StorePath storePath = FastdfsUtil.parseStorePath(fastdfsFileInfo.getGroupName(), fastdfsFileInfo.getFileName());
            return (InputStream)storageClient.downloadFile(storePath.getGroup(), storePath.getPath(), inputStream -> {
                int len;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = inputStream.read(buffer)) != -1) {
                    baos.write(buffer, 0, len);
                }
                return new ByteArrayInputStream(baos.toByteArray());
            });
        }
        catch (Exception e) {
            logger.error("plugin-file: Get File from Fast DFS failed", (Throwable)e);
            return null;
        }
    }

    private static StorePath parseStorePath(String groupName, String filePath) {
        if (StringUtils.isEmpty((Object)groupName) || StringUtils.isEmpty((Object)filePath)) {
            throw new FdfsUnsupportStorePathException("\u89e3\u6790\u6587\u4ef6\u8def\u5f84\u5931\u8d25");
        }
        return new StorePath(groupName, filePath);
    }

    public static String getExtByFileName(String fileName) {
        try {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        catch (Exception e) {
            throw new RuntimeException("plugin-file Upload File To FastDFS Error:Get File Ext By File Name Error.Please Check File Name [" + fileName + "]", e);
        }
    }
}

