package com.ohaotian.plugin.file;

import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.fastdfs.FastdfsConfig;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileClient;
import com.ohaotian.plugin.file.ftp.FtpConfig;
import com.ohaotian.plugin.file.ftp.FtpFileClient;
import com.ohaotian.plugin.file.minio.MinioConfig;
import com.ohaotian.plugin.file.minio.MinioFileClient;
import com.ohaotian.plugin.file.oss.OssConfig;
import com.ohaotian.plugin.file.oss.OssFileClient;

/**
 * 标题：FileClient工厂类
 * <p>
 * 说明：根据文件类型实例化FileClient
 * <br>
 * 时间：2018/07/09<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author ZhangCheng
 */
public class FileClientFactory {

    public static FileClient getOssClient(String endpoint, String accesskey, String accessKeySecret, String bucketName, String accessUrl) {
        OssConfig ossConfig = new OssConfig(endpoint, accesskey, accessKeySecret, bucketName, accessUrl);
        return getOssClient(ossConfig);
    }

    public static FileClient getOssClient(OssConfig ossConfig) {
        return getFileClient(FileType.OSS, ossConfig);
    }

    public static FileClient getFtpClient(String ftpHost, String ftpUser, String ftpPwd, Integer ftpPort, Integer ftpTimeout) {
        FtpConfig ftpConfig = new FtpConfig(ftpHost, ftpUser, ftpPwd, ftpPort, ftpTimeout);
        return getFtpClient(ftpConfig);
    }

    public static FileClient getFtpClient(FtpConfig ftpConfig) {
        return getFileClient(FileType.FTP, ftpConfig);
    }

    public static FileClient getFastdfsClient(String httpAntiStealToken, String httpSecretKey, Integer httpTrackerHttpPort, String trackerServers) {
        FastdfsConfig fastdfsConfig = new FastdfsConfig(httpAntiStealToken, httpSecretKey, httpTrackerHttpPort, trackerServers);
        return getFastdfsClient(fastdfsConfig);
    }

    public static FileClient getFastdfsClient(FastdfsConfig fastdfsConfig) {
        return getFileClient(FileType.FASTDFS, fastdfsConfig);
    }

    public static FileClient getMinioClient(MinioConfig minioConfig) {
        return getFileClient(FileType.MINIO, minioConfig);
    }

    private static FileClient getFileClient(FileType fileType, Object configObject) {
        switch (fileType) {
            case FTP:
                return new FtpFileClient((FtpConfig) configObject);
            case OSS:
                return new OssFileClient((OssConfig) configObject);
            case FASTDFS:
                return new FastdfsFileClient((FastdfsConfig) configObject);
            case MINIO:
                return new MinioFileClient((MinioConfig) configObject);
            default:
                throw new IllegalArgumentException("plugin-file config not support this file type [" + fileType + "]");
        }
    }
}
