package com.ohaotian.plugin.file.constant;

/**
 * 标题：文件类型
 * <p>
 * 说明：文件类型
 * <br>
 * 时间：2018/07/09<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author ZhangCheng
 */
public enum FileType {
    /**
     * 阿里云OSS
     */
    OSS,
    /**
     * FTP服务器
     */
    FTP,
    /**
     * Minio
     */
    MINIO,
    /**
     * FastDFS服务器
     */
    FASTDFS;

    public static boolean isOss(String fileType) {
        return OSS.name().equals(fileType);
    }

    public static boolean isFtp(String fileType) {
        return FTP.name().equals(fileType);
    }

    public static boolean isFastdfs(String fileType) {
        return FASTDFS.name().equals(fileType);
    }

    public static boolean isMinio(String fileType) {
        return MINIO.name().equals(fileType);
    }

}
