package com.ohaotian.plugin.file.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.*;
import com.ohaotian.plugin.file.util.SessionChannelUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;

public class FtpUtil {

    private static final Logger log = LoggerFactory.getLogger(FtpUtil.class);

    private static final String SPLITTER = "/";

    /** <br>
     * 适用场景: ftp文件上传<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param file
     * @param uploadPath
     * @return
     * @autho wesley
     * @time 2016年10月14日 下午5:39:09 */
    public static void uploadFile(File file, FtpConfig ftp, String uploadPath) {

        String fileName = file.getName();
        // 新文件名称
        String newFileName = fileName;

        // SFTP上传临时文件
        InputStream fis = null;
        SessionChannelUtil scu = null;
        ChannelSftp channelSftp = null;
        try {
            scu = new SessionChannelUtil();
            fis = new FileInputStream(file);
            Session session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());

            try {
                Vector<?> content = channelSftp.ls(uploadPath);
                if (content == null) {
                    channelSftp.mkdir(uploadPath);
                }

            }
            catch (SftpException e) {
                channelSftp.mkdir(uploadPath);
            }

            // 先上传.tmp 文件
            channelSftp.put(fis, uploadPath + newFileName + ".tmp", ChannelSftp.OVERWRITE);

            // 将.tmp 文件去掉.tmp
            try {
                channelSftp.rename(uploadPath + newFileName + ".tmp", uploadPath + newFileName);
            }
            catch (Exception e) {
                // 先删除
                channelSftp.rm(uploadPath + newFileName);
                channelSftp.rename(uploadPath + newFileName + ".tmp", uploadPath + newFileName);
            }
        }
        catch (Exception e) {
            log.error("连接远程服务器出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】同时检查路径【" + uploadPath + "是否有权限】", e);
            throw new RuntimeException( "连接远程服务器出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】同时检查文件路径【"
                    + uploadPath + "是否有权限】", e);
        }
        finally {
            if (scu != null) {
                try {
                    scu.closeSession();
                    fis.close();
                }
                catch (Exception e) {
                    log.error("关闭远程连接出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】", e);
                    throw new RuntimeException( "连接远程服务器出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort()
                            + "】同时检查文件路径【" + uploadPath + "是否有权限】", e);
                }
            }
        }
    }

    /** 通过流式上传<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param fileName
     * @param ftp ossConfig
     * @param fis inputStream
     * @param uploadPath
     * @autho liuce
     * @time 2016年11月6日 下午7:25:49 */
    public static void uploadFileByInputStream(String fileName, FtpConfig ftp, InputStream fis, String uploadPath) {
        // 新文件名称
        String newFileName = fileName;

        // SFTP上传临时文件
        SessionChannelUtil scu = null;
        ChannelSftp channelSftp = null;
        try {
            scu = new SessionChannelUtil();
            Session session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());

            try {
                Vector<?> content = channelSftp.ls(uploadPath);
                if (content == null) {
                    channelSftp.mkdir(uploadPath);
                }

            }
            catch (SftpException e) {
                mkdirs(channelSftp, uploadPath);
            }

            // 先上传.tmp 文件
            channelSftp.put(fis, uploadPath + newFileName + ".tmp", ChannelSftp.OVERWRITE);

            // 将.tmp 文件去掉.tmp
            channelSftp.rename(uploadPath + newFileName + ".tmp", uploadPath + newFileName);
        }
        catch (Exception e) {
            log.error("连接远程服务器出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】同时检查路径【" + uploadPath + "是否有权限】", e);
            throw new RuntimeException( "连接远程服务器出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】同时检查文件路径【"
                    + uploadPath + "是否有权限】", e);
        }
        finally {
            if (scu != null) {
                try {
                    scu.closeSession();
                }
                catch (Exception e) {
                    log.error("关闭远程连接出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】", e);
                    throw new RuntimeException( "连接远程服务器出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort()
                            + "】同时检查文件路径【" + uploadPath + "是否有权限】", e);
                }
            }
        }
    }

    private static void mkdirs(final ChannelSftp channelSftp, String uploadPath) {
        Arrays.stream(uploadPath.split(SPLITTER)).forEach(f -> {
            try {
                if (StringUtils.isNotBlank(f)){
                    channelSftp.cd(f);
                }
            } catch (SftpException e) {
                try {
                    channelSftp.mkdir(f);
                    channelSftp.cd(f);
                } catch (SftpException e1) {
                    throw new RuntimeException("Can't mkdir " + f,  e);
                }
            }

        });
        try {
            channelSftp.cd(channelSftp.getHome());
        } catch (SftpException e) {
            throw new RuntimeException("Can't return home",  e);
        }
    }

    /** <br>
     * 适用场景: ftp下载文件<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param filePath
     * @param ftp
     * @return
     * @autho wesley
     * @time 2016年10月17日 下午5:32:25 */
    public static File downloadFile(String filePath, FtpConfig ftp) {
        SessionChannelUtil scu = new SessionChannelUtil();
        Session session = null;

        String fileName = UUID.randomUUID() + filePath.substring(filePath.lastIndexOf("."), filePath.length());

        try {
            session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            ChannelSftp channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());
            String dir = System.getProperty("java.io.tmpdir");
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            fileName = dir + File.separator + fileName;
            // filePath = TempFileConstant.FILE_UPLOAD_PATH + filePath;
            channelSftp.get(filePath, fileName);
            log.debug("FileName:" + fileName);
        }
        catch (SftpException e) {
            throw new RuntimeException("文件不存在！");
        }
        catch (Exception e) {
            log.error("连接远程服务器出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】同时检查文件【" + filePath + "是否存在】", e);
            throw new RuntimeException( "连接远程服务器出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】", e);
        }
        finally {
            try {
                scu.closeSession();
            }
            catch (Exception e) {
                log.error("关闭远程连接出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】", e);
                throw new RuntimeException( "连接远程服务器出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】", e);
            }
        }
        return new File(fileName);
    }

    /** 根据文件路径列出查找符合条件的文件集合<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param filePath
     * @param suffix
     * @return
     * @autho liuce
     * @time 2016年10月27日 上午11:20:41 */
    @SuppressWarnings("unchecked")
    public static List<String> listFiles(String filePath, String suffix, FtpConfig ftp) {
        SessionChannelUtil scu = new SessionChannelUtil();
        Session session = null;
        Vector<Object> files = null;
        List<String> fileList = new ArrayList<String>();
        try {
            session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            ChannelSftp channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());
            files = channelSftp.ls(filePath);
            for (Object object : files) {
                String curStr = object.toString();
                curStr = curStr.substring(curStr.lastIndexOf(" ") + 1);
                // 检查文件名是否包含｛valiStr｝
                if (curStr.contains(suffix)) {
                    fileList.add(curStr);
                }
            }
        }
        catch (Exception e) {
            log.error("连接远程服务器出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】同时检查文件路径【" + filePath + "是否存在】", e);
        }
        finally {
            try {
                scu.closeSession();
            }
            catch (Exception e) {
                log.error("关闭远程连接出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】", e);
                // TODO 抛出固定异常
            }
        }
        return fileList;
    }

    /** <br>
     * 适用场景: ftp删除文件<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param filePath
     * @param ftp
     * @autho wesley
     * @time 2016年10月18日 上午10:58:57 */
    public static void deleteFile(String filePath, FtpConfig ftp) {
        SessionChannelUtil scu = new SessionChannelUtil();
        Session session = null;
        try {
            session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            ChannelSftp channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());
            channelSftp.rm(filePath);
        }
        catch (Exception e) {
            log.error("连接远程服务器出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】同时检查文件路径【" + filePath + "是否存在】", e);
            throw new RuntimeException("连接远程服务器出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】", e);
        }
        finally {
            try {
                scu.closeSession();
            }
            catch (Exception e) {
                log.error("关闭远程连接出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】", e);
                throw new RuntimeException( "连接远程服务器出错！请检查主机配置【host:" + ftp.getFileHost() + ",用户名:" + ftp.getFileUser() + ",端口:" + ftp.getFilePort() + "】", e);
            }
        }
    }

    public static InputStream downloadByInputStream(String filePath, FtpConfig ftpConfig) {
        try {
            return new FileInputStream(downloadFile(filePath, ftpConfig));
        } catch (FileNotFoundException e) {
            log.error(e.getMessage(), e);
        }
        return null;
    }
}
