package com.ohaotian.plugin.file.minio;

import lombok.Data;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * <br>
 * 标题: Minio配置实体类<br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 *
 * @autho gujb
 * @time 2023年12月1日10:17:51
 */
@Data
public class MinioConfig {
    /**
     * 终端节点
     */
    private String endPoint;

    /**
     * accessKey
     */
    private String accessKeyId;

    /**
     * accessKeySecret
     */
    private String accessKeySecret;

    /**
     * accessUrl允许访问的url
     */
    private String accessUrl;

    /**
     * bucketName
     */
    private String bucketName;

    public MinioConfig(String endPoint, String accessKeyId, String accessKeySecret, String bucketName, String accessUrl) {
        super();
        this.endPoint = endPoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.accessUrl = accessUrl;
        this.bucketName = bucketName;
    }

    @Override
    public String toString() {
        return "MinioConfig [endPoint=" + endPoint + ", accessKeyId=" + accessKeyId + ", accessKeySecret=" + accessKeySecret + ", accessUrl=" + accessUrl + ", bucketName=" + bucketName + "]";
    }

    public boolean check() {
        return isNotBlank(endPoint) && isNotBlank(accessKeyId) && isNotBlank(accessKeySecret) && isNotBlank(accessUrl) && isNotBlank(bucketName);
    }
}
