/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.fastdfs;

import com.ohaotian.plugin.file.fastdfs.FastdfsConfig;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastdfsUtil {
    private static final Logger logger = LoggerFactory.getLogger(FastdfsUtil.class);

    public static FastdfsFileInfo uploadFile(String fileName, FastdfsConfig config, InputStream fis, String uploadPath) {
        logger.info("plugin-file: Upload file to FastDFS File Name [{}]", (Object)fileName);
        long startTime = System.currentTimeMillis();
        StorageClient storageClient = null;
        String[] uploadResults = null;
        try {
            storageClient = FastdfsUtil.getTrackerClient(config.getProperties());
            uploadResults = storageClient.upload_file(FastdfsUtil.inputStreamToByte(fis), FastdfsUtil.getExtByFileName(fileName), null);
        }
        catch (IOException e) {
            logger.error("plugin-file: IO Exception when uploadind the file:" + fileName, (Throwable)e);
        }
        catch (Exception e) {
            logger.error("plugin-file: Non IO Exception when uploadind the file:" + fileName, (Throwable)e);
        }
        logger.info("plugin-file: upload_file time used:" + (System.currentTimeMillis() - startTime) + " ms");
        if (uploadResults == null && storageClient != null) {
            logger.error("plugin-file: upload file fail, error code:" + storageClient.getErrorCode());
            return new FastdfsFileInfo();
        }
        String groupName = uploadResults[0];
        String remoteFileName = uploadResults[1];
        logger.info("plugin-file: upload file successfully!!!group_name:" + groupName + ", remoteFileName: " + remoteFileName);
        return new FastdfsFileInfo(groupName, remoteFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(FastdfsFileInfo fastdfsFileInfo, FastdfsConfig config) {
        String dir = System.getProperty("java.io.tmpdir");
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        String fileName = dir + "/" + fastdfsFileInfo.getFileName();
        logger.debug("plugin-file: Download FastDFS File To Tmpdir File Name [{}]", (Object)fileName);
        InputStream inputStream = FastdfsUtil.downloadByInputStream(fastdfsFileInfo, config);
        if (inputStream == null) {
            return null;
        }
        File file = new File(fileName);
        File parentDir = new File(file.getParent());
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            byte[] b = new byte[1024];
            while (inputStream.read(b) != -1) {
                fos.write(b);
            }
        }
        catch (Exception e) {
            logger.error("plugin-file: Download FastDFS File Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    public static InputStream downloadByInputStream(FastdfsFileInfo fastdfsFileInfo, FastdfsConfig config) {
        try {
            StorageClient storageClient = FastdfsUtil.getTrackerClient(config.getProperties());
            byte[] fileByte = storageClient.download_file(fastdfsFileInfo.getGroupName(), fastdfsFileInfo.getFileName());
            return new ByteArrayInputStream(fileByte);
        }
        catch (IOException e) {
            logger.error("IO Exception: Get File from Fast DFS failed", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Non IO Exception: Get File from Fast DFS failed", (Throwable)e);
        }
        return null;
    }

    private static StorageClient getTrackerClient(Properties properties) throws IOException {
        TrackerServer trackerServer = FastdfsUtil.getTrackerServer(properties);
        return new StorageClient(trackerServer, null);
    }

    private static TrackerServer getTrackerServer(Properties properties) throws IOException {
        try {
            ClientGlobal.initByProperties((Properties)properties);
            logger.info("plugin-file:ClientGlobal.configInfo(): " + ClientGlobal.configInfo());
        }
        catch (Exception e) {
            logger.error("FastDFS Client Init Fail!", (Throwable)e);
            throw new RuntimeException("FastDFS Client Init Fail!" + e.getMessage(), e);
        }
        TrackerClient trackerClient = new TrackerClient();
        return trackerClient.getConnection();
    }

    public static String getExtByFileName(String fileName) {
        try {
            return fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        }
        catch (Exception e) {
            throw new RuntimeException("plugin-file Upload File To FastDFS Error:Get File Ext By File Name Error.Please Check File Name [" + fileName + "]", e);
        }
    }

    private static byte[] inputStreamToByte(InputStream inputStream) {
        try {
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("plugin-file Upload File To FastDFS Error:" + e.getMessage(), e);
        }
    }
}

