/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.minio;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.AbstractFileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.minio.MinioConfig;
import com.ohaotian.plugin.file.util.FileUtils;
import io.minio.MinioClient;
import io.minio.PutObjectOptions;
import java.io.File;
import java.io.InputStream;
import java.net.URLDecoder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class MinioFileClient
extends AbstractFileClient {
    private static final Logger log = LoggerFactory.getLogger(MinioFileClient.class);
    @Value(value="${plugin.file.blackType:exe;bat;js;html;dll;jsp;zip;rar}")
    private String fileUploadBlackType;
    private MinioConfig minioConfig;

    public MinioFileClient() {
    }

    public MinioFileClient(MinioConfig minioConfig) {
        this.minioConfig = minioConfig;
    }

    private MinioClient getMinioClient() {
        List<String> endpoints = this.parseEndpoints(this.minioConfig.getEndPoint());
        if (endpoints.isEmpty()) {
            throw new ZTBusinessException("\u672a\u914d\u7f6eMinIO\u7aef\u70b9");
        }
        ArrayList<String> shuffledEndpoints = new ArrayList<String>(endpoints);
        Collections.shuffle(shuffledEndpoints, new Random());
        Exception lastException = null;
        for (String endpoint : shuffledEndpoints) {
            try {
                MinioClient client = new MinioClient(endpoint, this.minioConfig.getAccessKeyId(), this.minioConfig.getAccessKeySecret());
                client.listBuckets();
                return client;
            }
            catch (Exception e) {
                lastException = e;
                log.warn("\u8fde\u63a5MinIO\u7aef\u70b9\u5931\u8d25: {}, \u5c1d\u8bd5\u4e0b\u4e00\u4e2a", (Object)endpoint, (Object)e);
            }
        }
        assert (lastException != null);
        throw new ZTBusinessException("\u65e0\u6cd5\u8fde\u63a5\u5230\u4efb\u4f55MinIO\u7aef\u70b9\uff1a" + lastException.getMessage());
    }

    private List<String> parseEndpoints(String endpointConfig) {
        ArrayList<String> endpoints = new ArrayList<String>();
        if (endpointConfig != null) {
            String[] parts;
            for (String part : parts = endpointConfig.split(",")) {
                String endpoint = part.trim();
                if (endpoint.isEmpty()) continue;
                endpoints.add(endpoint);
            }
        }
        return endpoints;
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream) {
        return this.uploadFileByInputStream(uploadFilePath, fileName, inputStream, null);
    }

    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream, String accessAuth) {
        String fileExtName = FileUtils.ext(fileName);
        if (!StringUtils.hasText((String)fileExtName)) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u65e0\u7c7b\u578b\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        if (!(!this.fileUploadBlackType.contains(fileExtName) || "mp4".equals(fileExtName) || "json".equals(fileExtName) || "txt".equals(fileExtName) || "p12".equals(fileExtName) || "pfx".equals(fileExtName) || "cer".equals(fileExtName))) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u8be5\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        LocalDate currentDate = LocalDate.now();
        UUID uuid = UUID.randomUUID();
        String datePath = String.format("%d/%02d/%02d/%s/", currentDate.getYear(), currentDate.getMonthValue(), currentDate.getDayOfMonth(), uuid.toString());
        String objectName = "";
        objectName = uploadFilePath.endsWith("/") || fileName.startsWith("/") ? uploadFilePath + datePath + fileName : uploadFilePath + "/" + datePath + fileName;
        try {
            MinioClient minioClient = this.getMinioClient();
            long partSize = 0x500000L;
            PutObjectOptions options = new PutObjectOptions(-1L, partSize);
            minioClient.putObject(this.minioConfig.getBucketName(), objectName, inputStream, options);
            String url = minioClient.getObjectUrl(this.minioConfig.getBucketName(), objectName);
            String path = MinioFileClient.keepAfterFourthSlash(url);
            String decodedPath = URLDecoder.decode(path, "UTF-8");
            return decodedPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Minio\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25," + e.getMessage());
            return null;
        }
    }

    public static String keepAfterFourthSlash(String url) {
        int count = 0;
        int index = 0;
        for (int i = 0; i < url.length(); ++i) {
            if (url.charAt(i) != '/' || ++count != 4) continue;
            index = i;
            break;
        }
        return url.substring(index + 1);
    }

    /*
     * Exception decompiling
     */
    @Override
    public File downloadToFile(String filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public InputStream downLoadToInputStream(String filePath) {
        try {
            MinioClient minioClient = this.getMinioClient();
            return minioClient.getObject(this.minioConfig.getBucketName(), filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Minio\u6587\u4ef6\u6d41\u4e0b\u8f7d\u5931\u8d25,filePath=" + filePath + ",\u5f02\u5e38=" + e.getMessage());
            return null;
        }
    }

    @Override
    protected FileType getFileType() {
        return FileType.MINIO;
    }
}

