/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file;

import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.constant.FileType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;

public abstract class AbstractFileClient
implements FileClient {
    private static final String SLANT_LINE = "/";

    @Override
    public abstract String uploadFileByInputStream(String var1, String var2, InputStream var3);

    @Override
    public abstract String uploadFileByInputStream(String var1, String var2, InputStream var3, String var4);

    @Override
    public abstract void setObjectAcl(String var1, String var2);

    @Override
    public abstract URL generatePresignedUrl(String var1, Date var2);

    @Override
    public abstract File downloadToFile(String var1);

    @Override
    public abstract InputStream downLoadToInputStream(String var1);

    @Override
    public List<String> listObjects(String prefix) {
        FileType fileType = this.getFileType();
        if (fileType == null) {
            throw new IllegalArgumentException("this class [" + this.getClass().getName() + "] method getFileType() is null");
        }
        throw new IllegalArgumentException(fileType.name() + " not support listFiles method");
    }

    @Override
    public List<String> listFiles(String filePath, String suffix) {
        FileType fileType = this.getFileType();
        if (fileType == null) {
            throw new IllegalArgumentException("this class [" + this.getClass().getName() + "] method getFileType() is null");
        }
        throw new IllegalArgumentException(fileType.name() + " not support listFiles method");
    }

    protected abstract FileType getFileType();

    protected final String getFilePath(String uploadFilePath, String fileName) {
        if (!uploadFilePath.endsWith(SLANT_LINE)) {
            uploadFilePath = uploadFilePath + SLANT_LINE;
        }
        return uploadFilePath + fileName;
    }

    public static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void safeClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

