/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.controller;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.file.FileClient;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin/file/download/"})
public class PluginFileDownloadController {
    private static final Logger log = LoggerFactory.getLogger(PluginFileDownloadController.class);
    @Value(value="${plugin.file.type:}")
    private String fileType;
    @Autowired
    private FileClient fileClient;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/**"})
    @BusiResponseBody
    public void download(HttpServletResponse response, HttpServletRequest request) throws IOException {
        InputStream in = null;
        String fullPath = request.getRequestURI();
        String url = "";
        String repalceStr = "/plugin/file/download";
        if (this.fileType.equals("OSS")) {
            repalceStr = "/plugin/file/download/";
        }
        int index = fullPath.indexOf(repalceStr);
        url = fullPath.substring(index + repalceStr.length(), fullPath.length());
        url = url.replaceAll("\\+", "%2B");
        url = URLDecoder.decode(url, "UTF-8");
        url = url.replaceAll("%2B", "+");
        InputStream inputStream = null;
        try {
            int bytesRead;
            if (url.startsWith("/")) {
                url = url.substring(1);
            }
            log.debug("plugin-file\u4e0b\u8f7d\uff1a{}", (Object)URLDecoder.decode(url, "UTF-8"));
            Object object = this.lock;
            synchronized (object) {
                inputStream = this.fileClient.downLoadToInputStream(url);
            }
            response.setCharacterEncoding("UTF-8");
            String fileName = url.substring(url.lastIndexOf("/") + 1, url.length());
            fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.toString());
            String mimeType = "application/octet-stream";
            String contentDisposition = "attachment; filename*=UTF-8''" + fileName;
            if (url.toLowerCase().endsWith(".pdf")) {
                mimeType = "application/pdf";
                contentDisposition = "inline; filename*=UTF-8''" + fileName;
            } else if (url.toLowerCase().endsWith(".html") || url.toLowerCase().endsWith(".htm")) {
                mimeType = "text/html";
                contentDisposition = "inline; filename*=UTF-8''" + fileName;
            }
            response.setContentType(mimeType);
            response.setHeader("Content-Disposition", contentDisposition);
            in = new BufferedInputStream(inputStream);
            ServletOutputStream out = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
        catch (Exception e) {
            log.error("plugin-file\u4e0b\u8f7d\uff1a{},\u53d1\u751f\u5f02\u5e38", (Object)url, (Object)e);
            String errMsg = "plugin-file\u4e0b\u8f7d" + url + ",\u53d1\u751f\u5f02\u5e38 " + e.getMessage();
            response.sendError(500, errMsg);
            response.setContentType("text/html;charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.write(errMsg);
            out.close();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u8f93\u5165\u6d41\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u8f93\u5165\u6d41Stream\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }
}

