/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.controller;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.controller.PluginUploadServiceRspBo;
import com.ohaotian.plugin.file.controller.PluginUploadServiceRspDataBo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/plugin/file"})
public class PluginFileUploadController {
    private static final Logger log = LoggerFactory.getLogger(PluginFileUploadController.class);
    @Value(value="${common.fileUploadPath:default/}")
    private String fileUploadPath;
    @Autowired
    private FileClient fileClient;

    @PostMapping(value={"/upload"})
    @BusiResponseBody
    public PluginUploadServiceRspBo upload(MultipartFile[] files) {
        PluginUploadServiceRspBo rspBo = new PluginUploadServiceRspBo();
        ArrayList<PluginUploadServiceRspDataBo> fileList = new ArrayList<PluginUploadServiceRspDataBo>();
        if (files == null || files.length == 0) {
            log.info("\u4e0a\u4f20\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
            return null;
        }
        for (MultipartFile file : files) {
            try {
                PluginUploadServiceRspDataBo rspDataBo = this.uploadFile(file);
                fileList.add(rspDataBo);
            }
            catch (Exception e) {
                log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: {}", (Object)e.getMessage());
                throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            }
        }
        rspBo.setFileList(fileList);
        return rspBo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginUploadServiceRspDataBo uploadFile(MultipartFile file) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            String fileName = file.getOriginalFilename();
            String path = this.fileClient.uploadFileByInputStream(this.fileUploadPath, fileName, inputStream);
            PluginUploadServiceRspDataBo rspDataBo = new PluginUploadServiceRspDataBo();
            rspDataBo.setUrl(path);
            rspDataBo.setName(fileName);
            PluginUploadServiceRspDataBo pluginUploadServiceRspDataBo = rspDataBo;
            return pluginUploadServiceRspDataBo;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25: {}", (Object)e.getMessage());
                }
            }
        }
    }
}

