/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.util;

import com.ohaotian.plugin.file.util.FileType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static String ext(String filename) {
        int index;
        log.info("\u83b7\u53d6\u6587\u4ef6\u6269\u5c55\u540d:" + filename);
        int queryIndex = filename.lastIndexOf("?");
        if (queryIndex != -1) {
            filename = filename.substring(0, queryIndex);
        }
        if ((index = filename.lastIndexOf(".")) == -1 || index == filename.length() - 1) {
            return null;
        }
        filename = filename.substring(index + 1).toLowerCase();
        log.info("\u5904\u7406\u540e\u6587\u4ef6\u6269\u5c55\u540d:" + filename);
        return filename;
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(InputStream is) {
        byte[] b = new byte[28];
        InputStream inputStream = null;
        try {
            is.read(b, 0, 28);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return FileUtils.bytesToHexString(b);
    }

    public static final byte[] input2byte(InputStream inStream) {
        try {
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = inStream.read(buff, 0, 100)) > 0) {
                swapStream.write(buff, 0, rc);
            }
            byte[] result = swapStream.toByteArray();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getType(byte[] bytes) {
        FileType[] fileTypes;
        String result = "";
        byte[] bytes2 = new byte[4];
        if (bytes.length == 0) {
            return "";
        }
        System.arraycopy(bytes, 0, bytes2, 0, 4);
        String fileHead = FileUtils.bytesToHexString(bytes2);
        if (fileHead == null || fileHead.length() == 0) {
            return null;
        }
        fileHead = fileHead.toUpperCase();
        for (FileType type : fileTypes = FileType.values()) {
            if (!type.getValue().contains(fileHead)) continue;
            result = type.name().toLowerCase();
            break;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(FileUtils.ext("https://gitlab.tydiczt.cn/ZT/Business-center/YouChu/yc-ucc.txt?2423434/comc"));
    }
}

