/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.constant;

import com.obs.services.model.AccessControlList;

public enum ObsFileAccessAuthEnum {
    REST_CANNED_PRIVATE("1", AccessControlList.REST_CANNED_PRIVATE),
    REST_CANNED_PUBLIC_READ("2", AccessControlList.REST_CANNED_PUBLIC_READ),
    REST_CANNED_PUBLIC_READ_WRITE("3", AccessControlList.REST_CANNED_PUBLIC_READ_WRITE),
    REST_CANNED_PUBLIC_READ_DELIVERED("4", AccessControlList.REST_CANNED_PUBLIC_READ_DELIVERED),
    REST_CANNED_PUBLIC_READ_WRITE_DELIVERED("5", AccessControlList.REST_CANNED_PUBLIC_READ_WRITE_DELIVERED),
    REST_CANNED_AUTHENTICATED_READ("6", AccessControlList.REST_CANNED_AUTHENTICATED_READ),
    REST_CANNED_BUCKET_OWNER_READ("7", AccessControlList.REST_CANNED_BUCKET_OWNER_READ),
    REST_CANNED_BUCKET_OWNER_FULL_CONTROL("8", AccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL),
    REST_CANNED_LOG_DELIVERY_WRITE("9", AccessControlList.REST_CANNED_LOG_DELIVERY_WRITE);

    private final String code;
    private final AccessControlList accessAuth;

    private ObsFileAccessAuthEnum(String code, AccessControlList accessAuth) {
        this.code = code;
        this.accessAuth = accessAuth;
    }

    public String getCode() {
        return this.code;
    }

    public AccessControlList getAccessAuth() {
        return this.accessAuth;
    }

    public static AccessControlList getAccessControlByCode(String code) {
        for (ObsFileAccessAuthEnum anEnum : ObsFileAccessAuthEnum.values()) {
            if (!anEnum.getCode().equals(code)) continue;
            return anEnum.getAccessAuth();
        }
        return null;
    }
}

