package com.ohaotian.plugin.mq.proxy.ext.aliyunmq;


import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.PropertyKeyConst;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.constants.Strategy;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import com.ohaotian.plugin.mq.proxy.impl.MQUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.DependsOn;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;

public class AliyunMQMessageConsumerRegister implements MQRegister, ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    private Properties mergedProps = new Properties();
    //@ApolloConfig
    //private Config apolloConfig= ConfigService.getAppConfig();
    private String defaultValue = "defaultValue";
    private Consumer consumer;
    private boolean started;



    @DependsOn("apolloConfigVO")
    public void register(ConsumerRegisterInfo consumerInfo, ApolloConfigVO apolloConfigVO) {
        String subject = consumerInfo.getSubject();
        ProxyMessageType[] messageTypes = consumerInfo.getMessageTypes();
        for (ProxyMessageType messageType : messageTypes) {
            if (supportConcurrently(messageType)) {
                continue;
            }
            throw new UnsupportedOperationException("Unsuppoorted messageType[" + messageType + "] for subject[" + consumerInfo.getSubject() + "]");
        }
        Properties config = new Properties();
        Properties consumerProps = consumerInfo.getProperties();

//        config.put(PropertyKeyConst.ConsumerId, consumerInfo.getCid());
        config.put(PropertyKeyConst.AccessKey, consumerProps.getProperty("mq.accessKey",apolloConfigVO.getAccessKey()));
        config.put(PropertyKeyConst.SecretKey, consumerProps.getProperty("mq.secretKey", apolloConfigVO.getSecretKey()));


        logger.info("***********是否使用gid***********");
        if(StringUtils.isEmpty(apolloConfigVO.getSupportGID())){
            logger.info("***********不使用gid***********");
            config.put(PropertyKeyConst.ConsumerId, consumerInfo.getCid());
            config.put(PropertyKeyConst.ONSAddr, consumerProps.getProperty("mq.onsAddr", apolloConfigVO.getOnsAddr()));
        }else{
            logger.info("***********使用gid***********"+apolloConfigVO.getSupportGID());
            config.put(PropertyKeyConst.ConsumerId, consumerInfo.getCid());
            config.put(PropertyKeyConst.GROUP_ID, consumerInfo.getCid());
            config.put(PropertyKeyConst.NAMESRV_ADDR, consumerProps.getProperty("mq.onsAddr", apolloConfigVO.getOnsAddr()));
        }

        this.consumer = ONSFactory.createConsumer(config);
        consumer.subscribe(subject, MQUtils.tags2Line(consumerInfo.getTags()), new AliyunMessageListener(consumerInfo.getConsumerWrappers()));
    }

    private boolean supportConcurrently(ProxyMessageType messageType) {
        return messageType == ProxyMessageType.ASYNCHRONOUS || messageType == ProxyMessageType.SYNCHRONIZATION || messageType == ProxyMessageType.ONEWAY || messageType == ProxyMessageType.TRANSACTION;
    }

    protected static ProxyMessage getMessage(Message aliyunMessage) {
        ProxyMessage message;
        try {
            message = new ProxyMessage(aliyunMessage.getTopic(), aliyunMessage.getTag(), new String(aliyunMessage.getBody(), "UTF-8"));
            message.setMessageId(aliyunMessage.getMsgID());
        } catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("aliyumMessage 2 ProxyMessage Error", e);
        }
        return message;
    }

    public boolean support(String strategy) {
        return AliyunMQMessageConsumerRegister.strategySupported(strategy);
    }

    public static boolean strategySupported(String strategy) {
        return Strategy.isAliyunMQ(strategy);
    }

    public void startup() {
        if (started) {
            return;
        }
        consumer.start();
        started = true;
    }

    public void shutdown() {
        if (!started) {
            return;
        }
        consumer.shutdown();
        started = false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, Properties> propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap(props, mergedProps);
            }
        }
    }
}
