package com.ohaotian.plugin.mq.proxy.ext.rabbitmq;

import com.ohaotian.plugin.mq.proxy.CacheStore;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.rabbitmq.client.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/**
 * @描述：
 * @作者： 李佳琪
 * @时间 2020-04-10
 */
public class RabbitMqMessageSender  implements ProxyMessageProducerEx, ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    private CacheStore cacheStore;
    private final Properties mergedProps = new Properties();
    private Channel channel;

    private ProxyMessageConfig messageConfig;
    private final String subject;
    private final Map<ProxyMessageType, Set<String>> typeTagsMapping;
    private String exchangeName;

    public RabbitMqMessageSender(ProxyMessageConfig messageConfig, Map<ProxyMessageType, Set<String>> typeTagsMapping) {
        logger.info("[" + this.getClass().getName() + "] rabbitMQ----");
        this.subject = messageConfig.getSubject();
        this.messageConfig = messageConfig;
        this.typeTagsMapping = typeTagsMapping;
    }

    @Override
    public void startup() {
        channel = RabbitMQUtil.getChannelInstance("消息生产者",mergedProps);
        try {
            // 声明交换机 (交换机名, 交换机类型, 是否持久化, 是否自动删除, 是否是内部交换机, 交换机属性);
            Properties consumerProps = messageConfig.getProperties();
            exchangeName = consumerProps.getProperty("mq.exchangeName", mergedProps.getProperty("mq.exchangeName"));
            channel.exchangeDeclare(exchangeName, BuiltinExchangeType.TOPIC); //不持久化，不自动删除
            //每次只向消费者发送一条消息,消费者使用后,手动确认后,才会发送另外一条
            channel.basicQos(0, 1, false);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public ProxySendResult send(ProxyMessage message) {
        // 设置消息属性 发布消息 (交换机名, Routing key, 可靠消息相关属性 后续会介绍, 消息属性, 消息体);
        AMQP.BasicProperties basicProperties = new AMQP.BasicProperties().builder().deliveryMode(2).contentType("UTF-8").build();
        String testConsumerTag = "";
        try {
            channel.confirmSelect();
            channel.basicPublish(exchangeName, message.getSubject(), basicProperties, message.getContent().getBytes("utf-8"));
            if (channel.waitForConfirms()) {
                logger.info("消息发送成功");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getProxySendResult(testConsumerTag);
    }

    private ProxySendResult getProxySendResult(String sendResult) {
        ProxySendResult proxySendResult;
        proxySendResult = new ProxySendResult();
        proxySendResult.setMsgId(sendResult);
        proxySendResult.setStatus(ProxySendResult.SEND_OK);
        return proxySendResult;
    }

    @Override
    public void send(ProxyMessage message, ProxySendCallback sendCallback) {

    }

    @Override
    public void sendOneway(ProxyMessage message) {

    }

    @Override
    public ProxySendResult sendInTransaction(ProxyMessage proxyMessage, ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        return null;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, Properties> propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap(props, mergedProps);
            }
        }
        this.cacheStore = applicationContext.getBean(CacheStore.class);
    }
}
