package com.ohaotian.plugin.mq.proxy.impl;

import com.ohaotian.plugin.mq.proxy.ext.ExtInfo;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import java.io.InputStream;
import java.util.*;

public final class MQUtils {
    private static final PathMatchingResourcePatternResolver PMRPR = new PathMatchingResourcePatternResolver(ExtInfo.class.getClassLoader());
    private static final Map<String, ExtInfo> EXT_INFO_MAPPING;
    static {
        Resource resource = PMRPR.getResource("classpath:/" + ExtInfo.class.getPackage().getName().replace(".", "/") + "/mq.handlers");
        Properties props = new Properties();
        try {
            Map<String, ExtInfo> extInfoMapping = new HashMap<String, ExtInfo>();
            InputStream ins = resource.getInputStream();
            props.load(ins);
            ins.close();
            Set<Object> keySet = props.keySet();
            for (Object keyObj : keySet) {
                String key = (String) keyObj;
                key = key.substring(0, key.indexOf("."));
                if (extInfoMapping.containsKey(key)) {
                    continue;
                }
                extInfoMapping.put(key, new ExtInfo());
            }
            Set<Map.Entry<String, ExtInfo>> entrySet = extInfoMapping.entrySet();
            for (Map.Entry<String, ExtInfo> entry : entrySet) {
                ExtInfo extInfo = entry.getValue();
                extInfo.setRegisterClass((Class<MQRegister>) Class.forName(props.getProperty(entry.getKey() + ".register")));
                if (!extInfo.registerSupported(entry.getKey())) {
                    throw new IllegalStateException("handler[" + extInfo.getRegisterClass().getName() + "] key must be [" + entry.getKey() + ".register]");
                }
                extInfo.setSenderClass((Class<ProxyMessageProducerEx>) Class.forName(props.getProperty(entry.getKey() + ".sender")));
            }
            EXT_INFO_MAPPING = Collections.unmodifiableMap(extInfoMapping);
        } catch (IllegalStateException e) {
            throw e;
        } catch (Throwable e) {
            throw new IllegalStateException("init mq-proxy handlers error", e);
        }
    }

    public static Map<String, ExtInfo> getExtInfoMapping() {
        return EXT_INFO_MAPPING;
    }

    public static String tags2Line(Set<String> tagSet) {
        StringBuilder tagLine = new StringBuilder();
        String seprator = null;
        for (String tag : tagSet) {
            if (seprator != null) {
                tagLine.append(seprator);
            } else {
                seprator = "||";
            }
            tagLine.append(tag);
        }
        return tagLine.toString();
    }
}
