package com.ohaotian.plugin.mq.proxy;

import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;

/**
 * 标题：消息消费者
 * <p>
 * 说明：消息消费者
 * <br>
 * 时间：2018/06/26<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author Please creater enter the name
 * @author ZhangCheng
 */
public interface ProxyMessageConsumer extends ProxyMessageConfig {
    /**
     * 当接收到消息时触发
     *
     * @param message 消息
     * @return 消费者状态
     */
    ProxyConsumerStatus onMessage(ProxyMessage message);

    /**
     * 获取 消费者ID
     *
     * @return 消费者ID
     */
    String getId();
}
