/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.rocketmq;

import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ext.rocketmq.RocketMQMessageConsumerRegister;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import java.util.List;
import java.util.Set;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;

public class RocketMQMessageListener
implements MessageListenerConcurrently,
MessageListenerOrderly {
    private final Set<IProxyMessageConsumerWrapper> localConsumers;

    RocketMQMessageListener(Set<IProxyMessageConsumerWrapper> localConsumers) {
        this.localConsumers = localConsumers;
    }

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> messageExts, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        this.processMessage(messageExts, this.localConsumers);
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> messageExts, ConsumeOrderlyContext consumeOrderlyContext) {
        this.processMessage(messageExts, this.localConsumers);
        return ConsumeOrderlyStatus.SUCCESS;
    }

    private void processMessage(List<MessageExt> messageExts, Set<IProxyMessageConsumerWrapper> localConsumers) {
        for (MessageExt messageExt : messageExts) {
            ProxyMessage message = RocketMQMessageConsumerRegister.getMessage(messageExt);
            for (IProxyMessageConsumerWrapper proxyMessageConsumer : localConsumers) {
                if (!proxyMessageConsumer.needWrapper(message.getSubject(), message.getTag())) continue;
                proxyMessageConsumer.onMessage(message);
            }
        }
    }
}

