package com.ohaotian.plugin.mq.proxy.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.ext.ExtInfo;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.util.Map;
import java.util.Set;

public class ProxyMessageSenderWrapper implements ProxyMessageProducerEx, ApplicationContextAware {
    private final ProxyMessageProducerEx localMessageSender;
    private boolean started;

    ProxyMessageSenderWrapper(String strategy, ProxyMessageConfig messageConfig, Map<ProxyMessageType, Set<String>> typeTagsMapping) {
        ExtInfo extInfo = MQUtils.getExtInfoMapping().get(strategy);
        if (extInfo == null) {
            throw new IllegalStateException("mq.strategy[" + strategy + "] unsupported");
        }
        localMessageSender = extInfo.newProducer(messageConfig, typeTagsMapping);
    }

    public ProxySendResult send(ProxyMessage message) {
        return localMessageSender.send(message);
    }

    public void send(ProxyMessage message, ProxySendCallback sendCallback) {
        localMessageSender.send(message, sendCallback);
    }

    public void sendOneway(ProxyMessage message) {
        localMessageSender.sendOneway(message);
    }

    public ProxySendResult sendInTransaction(ProxyMessage proxyMessage, ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        return localMessageSender.sendInTransaction(proxyMessage, localTransactionExecuter, arg);
    }

    public void startup() {
        if (started) {
            return;
        }
        this.localMessageSender.startup();
        started = true;
    }

    public void shutdown() {
        if (!started) {
            return;
        }
        this.localMessageSender.shutdown();
        started = false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.localMessageSender instanceof ApplicationContextAware) {
            ((ApplicationContextAware) this.localMessageSender).setApplicationContext(applicationContext);
        }
    }
}
