/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.redismq;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.constants.Strategy;
import com.ohaotian.plugin.mq.proxy.ext.redismq.RedisMQMessageListener;
import com.ohaotian.plugin.mq.proxy.ext.redismq.RedisMqMessageSender;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.rocketmq.client.consumer.MQPushConsumer;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;

public class RedisMQMessageConsumerRegister
implements MQRegister,
ApplicationContextAware {
    private Map<String, MQPushConsumer> consumerMapping = new HashMap<String, MQPushConsumer>();
    private boolean started;
    private Properties mergedProps = new Properties();
    private JedisPool jedisPool;
    private List<Jedis> jedisList = new ArrayList<Jedis>();
    private ConsumerRegisterInfo consumerInfo;
    private final ThreadLocal<ObjectMapper> objectMapperThreadLocal = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };

    @Override
    public void register(ConsumerRegisterInfo consumerInfo, ApolloConfigVO apolloConfigVO) {
        ProxyMessageType[] messageTypes;
        this.consumerInfo = consumerInfo;
        for (ProxyMessageType messageType : messageTypes = consumerInfo.getMessageTypes()) {
            if (this.supportConcurrently(messageType)) continue;
            throw new UnsupportedOperationException("Unsuppoorted messageType[" + (Object)((Object)messageType) + "] for subject[" + consumerInfo.getSubject() + "]");
        }
    }

    private boolean supportConcurrently(ProxyMessageType messageType) {
        return messageType == ProxyMessageType.ASYNCHRONOUS || messageType == ProxyMessageType.SYNCHRONIZATION || messageType == ProxyMessageType.ONEWAY || messageType == ProxyMessageType.TRANSACTION;
    }

    @Override
    public boolean support(String strategy) {
        return RedisMQMessageConsumerRegister.strategySupported(strategy);
    }

    public static boolean strategySupported(String strategy) {
        return Strategy.isRedisMQ(strategy);
    }

    @Override
    public void startup() {
        if (this.started) {
            return;
        }
        GenericObjectPoolConfig redisConfig = new GenericObjectPoolConfig();
        URI redisUri = null;
        String redisCfgUrl = this.consumerInfo.getProperties().getProperty("mq.redis.url", this.mergedProps.getProperty("mq.redis.url"));
        try {
            redisUri = new URI(redisCfgUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("[" + redisCfgUrl + "] parsed error", e);
        }
        this.jedisPool = new JedisPool(redisConfig, redisUri.getHost(), redisUri.getPort(), 3000, redisUri.getUserInfo(), 0);
        ArrayList<String> channelList = new ArrayList<String>();
        for (String tag : this.consumerInfo.getTags()) {
            channelList.add(RedisMqMessageSender.getChannel(new ProxyMessage(this.consumerInfo.getSubject(), tag, null)));
        }
        final String[] channels = new String[channelList.size()];
        channelList.toArray(channels);
        final Jedis jedis = this.jedisPool.getResource();
        new Thread(new Runnable(){

            @Override
            public void run() {
                jedis.subscribe((JedisPubSub)new RedisMQMessageListener(RedisMQMessageConsumerRegister.this.jedisPool, RedisMQMessageConsumerRegister.this.consumerInfo.getConsumerWrappers()), channels);
                RedisMQMessageConsumerRegister.this.jedisList.add(jedis);
            }
        }).start();
        this.started = true;
    }

    @Override
    public void shutdown() {
        if (!this.started) {
            return;
        }
        for (Jedis jedis : this.jedisList) {
            jedis.close();
        }
        this.jedisList.clear();
        this.jedisPool.close();
        this.jedisPool = null;
        this.started = false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)this.mergedProps);
            }
        }
    }
}

