/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.tonglkq;

import com.ohaotian.license.verify.service.LicenseVerifyService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageException;
import com.tongtech.tmqi.QueueConnectionFactory;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.jms.connection.CachingConnectionFactory;

public class TongLKQMessageSender
implements ProxyMessageProducerEx,
ApplicationContextAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TongLKQMessageSender.class);
    private LicenseVerifyService licenseVerifyService;
    private Environment environment;
    private final Map<ProxyMessageType, Set<String>> typeTagsMapping;
    private ProxyMessageConfig messageConfig;
    private final String subject;
    private CachingConnectionFactory cachingConnectionFactory;
    private QueueConnection queueConnection;
    private QueueSession queueSession;

    public TongLKQMessageSender(ProxyMessageConfig messageConfig, Map<ProxyMessageType, Set<String>> typeTagsMapping) {
        log.info("[" + this.getClass().getName() + "] required properties[mq.endpoint]");
        this.subject = messageConfig.getSubject();
        this.messageConfig = messageConfig;
        this.typeTagsMapping = typeTagsMapping;
    }

    @Override
    public void startup() {
        log.debug("\u5f00\u59cb\u521d\u59cb\u5316 TLQ \u8fde\u63a5\u6c60\u548c\u751f\u4ea7\u8005");
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String tlqUrl = this.environment.getProperty("mq.endpoint");
        try {
            QueueConnectionFactory rawFactory = new QueueConnectionFactory();
            rawFactory.setProperty("tmqiAddressList", tlqUrl);
            this.cachingConnectionFactory = new CachingConnectionFactory((ConnectionFactory)rawFactory);
            this.cachingConnectionFactory.setSessionCacheSize(5);
            this.cachingConnectionFactory.setReconnectOnException(true);
            this.queueConnection = (QueueConnection)this.cachingConnectionFactory.createConnection();
            this.queueSession = this.queueConnection.createQueueSession(false, 1);
            this.queueConnection.start();
        }
        catch (Exception jmsEx) {
            log.error("TLQ \u8fde\u63a5\u521d\u59cb\u5316\u5931\u8d25", (Throwable)jmsEx);
            if (this.queueSession != null) {
                try {
                    this.queueSession.close();
                }
                catch (JMSException e) {
                    log.warn("\u5173\u95ed Session \u5931\u8d25", (Throwable)e);
                }
            }
            if (this.queueConnection != null) {
                try {
                    this.queueConnection.close();
                }
                catch (JMSException e) {
                    log.warn("\u5173\u95ed Connection \u5931\u8d25", (Throwable)e);
                }
            }
            throw new ProxyMessageException("TLQ \u8fde\u63a5\u521d\u59cb\u5316\u5931\u8d25", jmsEx);
        }
    }

    @Override
    public void shutdown() {
        log.info("\u5173\u95ed TLQ \u8fde\u63a5\u548c\u4f1a\u8bdd");
        if (this.queueSession != null) {
            try {
                this.queueSession.close();
            }
            catch (JMSException e) {
                log.warn("\u5173\u95ed Session \u5931\u8d25", (Throwable)e);
            }
        }
        if (this.queueConnection != null) {
            try {
                this.queueConnection.close();
            }
            catch (JMSException e) {
                log.warn("\u5173\u95ed Connection \u5931\u8d25", (Throwable)e);
            }
        }
        if (this.cachingConnectionFactory != null) {
            this.cachingConnectionFactory.destroy();
        }
    }

    @Override
    public ProxySendResult send(ProxyMessage message) {
        ProxySendResult proxySendResult;
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        QueueSender queueSender = null;
        try {
            TextMessage sendMessage = this.queueSession.createTextMessage(message.getContent());
            if (sendMessage != null) {
                String messageId = message.getMessageId();
                if (messageId == null || messageId.trim().isEmpty()) {
                    messageId = UUID.randomUUID().toString();
                }
                sendMessage.setStringProperty("messageId", messageId);
                sendMessage.setStringProperty("tag", message.getTag());
                Queue queue = this.queueSession.createQueue(message.getSubject());
                queueSender = this.queueSession.createSender(queue);
                queueSender.send((Message)sendMessage);
                proxySendResult = this.getProxySendResult(true);
            } else {
                proxySendResult = this.getProxySendResult(false);
            }
        }
        catch (Exception e) {
            log.error("send message error", (Throwable)e);
            throw new ProxyMessageException("send subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
        finally {
            if (queueSender != null) {
                try {
                    queueSender.close();
                }
                catch (JMSException e) {
                    log.warn("close QueueSender error", (Throwable)e);
                }
            }
        }
        return proxySendResult;
    }

    private ProxySendResult getProxySendResult(boolean send) {
        ProxySendResult proxySendResult = new ProxySendResult();
        if (send) {
            proxySendResult.setStatus("SEND_OK");
        } else {
            proxySendResult.setStatus("SEND_FAIL");
        }
        return proxySendResult;
    }

    @Override
    public void send(ProxyMessage message, ProxySendCallback sendCallback) {
        log.error("tlq not support");
    }

    @Override
    public void sendOneway(ProxyMessage message) {
        log.error("tlq not support");
    }

    @Override
    public ProxySendResult sendInTransaction(ProxyMessage proxyMessage, ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        log.error("tlq not support");
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.licenseVerifyService = (LicenseVerifyService)applicationContext.getBean(LicenseVerifyService.class);
        this.environment = applicationContext.getEnvironment();
    }

    public void destroy() throws Exception {
        this.shutdown();
    }
}

