package com.ohaotian.plugin.mq;

/***************************************************
 运行示例代码的前置条件：

 通过下面两种方式可以引入依赖(任选一种)
 1、Maven方式引入依赖
 <dependency>
 <groupId>com.aliyun.openservices</groupId>
 <artifactId>ons-client</artifactId>
 <version>1.1.5</version>
 </dependency>

 2、下载依赖Jar包
 http://onsteam.oss-cn-hangzhou.aliyuncs.com/aliyun-ons-client-java.zip

 ***************************************************/

import java.util.Date;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.bo.MqConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;

/** <br>
 * 标题: ons检查机制类<br>
 * 描述: <br>
 * 公司: www.chinaunicom.com<br>
 * 
 * @autho liuce
 * @time 2016-8-9 下午7:33:37 */
public class TransactionCheckListenerImpl implements LocalTransactionChecker {

	private final static Logger  log           = LoggerFactory.getLogger(TransactionCheckListenerImpl.class);

	private final static boolean isDebugEnable = log.isDebugEnabled();

	/** 消息接口 */
	// private MessageInfoService messageInfoService;

	/** 返回 消息接口
	 * 
	 * @return 消息接口 */
	// public MessageInfoService getMessageInfoService() {
	// return messageInfoService;
	// }

	/** 设置 消息接口
	 * 
	 * @param messageInfoService
	 *        消息接口 */
	// public void setMessageInfoService(MessageInfoService messageInfoService) {
	// this.messageInfoService = messageInfoService;
	// }

	/** 缓存service */
	private CacheClient cacheService;

	/** 设置 消息接口
	 * 
	 * @param cacheService
	 *        消息接口 */
	public void setCacheService(CacheClient cacheService) {
		this.cacheService = cacheService;
	}

	@Override
	public TransactionStatus check(Message msg) {
		// MessageInfoBO msgInfo = messageInfoService.selectByPrimaryKey(msg.getMsgID());
		String msgId = msg.getMsgID();
		String key = msg.getKey();
		String topic = msg.getTopic();
		String tag = msg.getTag();
		Object body = null;

		/*if (isDebugEnable) {
			try {
	            body = SerializeUtils.deserialize(msg.getBody());
            }
            catch (Exception e) {
            }
		}*/

		Integer status = (Integer) cacheService.get(msgId);
		if (status != null) {
			if (MqConstants.PRODUCT_SEND_STATUS_SUCCESS.equals(status)) {
				if (isDebugEnable) {
					log.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "} key={" + key + "}消息发送成功! body={" + body + "}");
				}
				try {
					cacheService.delete(msgId);
					cacheService.delete("C_" + msgId);
				}
				catch (Exception e) {
					log.error("删除redis中key{" + msgId + "} 和 key {" + "C_" + msgId + "}时异常", e);
				}
				return TransactionStatus.CommitTransaction;
			}
			else if (MqConstants.PRODUCT_SEND_STATUS_FAILURE.equals(status)) {
				if (isDebugEnable) {
					log.debug("check  msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "} key={" + key + "}消息发送失败！ body={" + body + "}");
				}
				try {
					cacheService.delete(msgId);
					cacheService.delete("C_" + msgId);
				}
				catch (Exception e) {
					log.error("删除redis中key{" + msgId + "} 和 key {" + "C_" + msgId + "}时异常", e);
				}
				return TransactionStatus.RollbackTransaction;
			}
			else {
				log.error("未知的半事务消息状态{" + status + "}msg{" + msg + "}");
				return TransactionStatus.RollbackTransaction;
			}
		}
		else {
			Integer cstatus = (Integer) cacheService.get("C_" + msgId);
			if (cstatus != null) {
				Long dateTime = cacheService.getExpireTimeByKey("C_" + msgId);
				if (dateTime != null && (dateTime == -1 || dateTime == -2)) {
					cacheService.delete(msgId);
					if (isDebugEnable) {
						log.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "}  key={" + key + "}----时间过长，删除消息！ body={" + body + "}");
					}
					return TransactionStatus.RollbackTransaction;
				}
				else {
					if (isDebugEnable) {
						log.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "}  key={" + key + "} 状态未知！ body={" + body + "}");
					}
					return TransactionStatus.Unknow;
				}
			}
			else {
				if (isDebugEnable) {
					log.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "}  key={" + key + "} 第一次check不到，添加一条消息 body={" + body + "}");
				}
				// 设置的超时时间为当前时间
				cacheService.put("C_" + msgId, MqConstants.PRODUCT_SEND_STATUS_TIMETOOLONG, (int) (MqConstants.MQ_EXPIRE / 1000));
			}

			return TransactionStatus.Unknow;
		}
	}

	public static void main(String[] args) {
		long start = new Date().getTime();
		System.out.println(start);

		try {
			Thread.sleep(5001);
		}
		catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		long end = new Date().getTime();
		System.out.println((end - start) > MqConstants.MQ_TRAN_EXPIRE);
	}

}
