package com.ohaotian.plugin.security.config;

import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.util.CommonUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.Assert;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class ZTCasAuthenticationEntryPoint implements AuthenticationEntryPoint, InitializingBean {
    private ServiceProperties serviceProperties;
    private String loginUrl;
    private boolean encodeServiceUrlWithSessionId = true;
    //区分登录参数名称
    public static final String LOGIN_TYPE_COLUMN_MODE = "mode";
    public static final String DEFAULT_MODE = "1";
    private String mode = DEFAULT_MODE;


    public ZTCasAuthenticationEntryPoint() {
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.hasLength(this.loginUrl, "loginUrl must be specified");
        Assert.notNull(this.serviceProperties, "serviceProperties must be specified");
        Assert.notNull(this.serviceProperties.getService(), "serviceProperties.getService() cannot be null.");
    }

    @Override
    public final void commence(HttpServletRequest servletRequest, HttpServletResponse response, AuthenticationException authenticationException) throws IOException, ServletException {
        preCommence(servletRequest, response);
        final String urlEncodedService = createServiceUrl(servletRequest, response);
        final String redirectUrl = createRedirectUrl(urlEncodedService);
        response.sendRedirect(redirectUrl);
    }

    protected String createServiceUrl(HttpServletRequest request, HttpServletResponse response) {
        return CommonUtils.constructServiceUrl((HttpServletRequest) null, response, this.serviceProperties.getService(), (String) null, this.serviceProperties.getArtifactParameter(), this.encodeServiceUrlWithSessionId);
    }

    protected String createRedirectUrl(String serviceUrl) {

        CommonUtils.constructRedirectUrl(getLoginUrl(), getServiceProperties().getServiceParameter(), serviceUrl, getServiceProperties().isSendRenew(), false);
        String url = CommonUtils.constructRedirectUrl(this.loginUrl, this.serviceProperties.getServiceParameter(), serviceUrl, this.serviceProperties.isSendRenew(), false);
        return StringUtils.join(url, "&mode=", mode);
    }

    protected void preCommence(HttpServletRequest request, HttpServletResponse response) {
        String newMode = request.getParameter(LOGIN_TYPE_COLUMN_MODE);
        if (StringUtils.isBlank(newMode)) {
            Object objMode = request.getAttribute(LOGIN_TYPE_COLUMN_MODE);
            newMode = objMode == null ? null : objMode.toString();
        }

        this.setMode(StringUtils.isNotBlank(newMode) ? newMode : DEFAULT_MODE);
    }

    public final String getLoginUrl() {
        return this.loginUrl;
    }

    public final ServiceProperties getServiceProperties() {
        return this.serviceProperties;
    }

    public final void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public final void setServiceProperties(ServiceProperties serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public final void setEncodeServiceUrlWithSessionId(boolean encodeServiceUrlWithSessionId) {
        this.encodeServiceUrlWithSessionId = encodeServiceUrlWithSessionId;
    }

    protected boolean getEncodeServiceUrlWithSessionId() {
        return this.encodeServiceUrlWithSessionId;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}