package com.ohaotian.plugin.uuid.security.dubboFilter;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.*;
import com.ohaotian.plugin.uuid.base.bo.ReqInfo;
import com.ohaotian.plugin.uuid.base.exception.ZTBusinessException;
import com.ohaotian.plugin.uuid.common.util.BeanMapper;
import com.ohaotian.plugin.uuid.common.util.ValidationResult;
import com.ohaotian.plugin.uuid.common.util.ValidationUtil;
import com.ohaotian.plugin.uuid.security.entity.UserInfo;
import com.ohaotian.plugin.uuid.security.utils.SecurityHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;


@Activate(group = Constants.CONSUMER)
public class DubboServiceFilter implements Filter {

    private final static Logger log = LoggerFactory.getLogger(DubboServiceFilter.class);


    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) {
        Result result = null;
        Long takeTime = 0L;
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        if (userInfo != null) {
            Object[] arguments = invocation.getArguments();
            for (Object n : arguments) {
                List<ValidationResult> validationResults = ValidationUtil.validateModel(n);
                if (validationResults.size() > 0) {
                    StringBuffer msg = new StringBuffer();
                    validationResults.forEach(s -> {
                        msg.append(s.getValidationMsg() + "<br/>");
                    });
                    throw new ZTBusinessException(msg.toString());
                }
                if (n instanceof ReqInfo && userInfo != null) {
                    ReqInfo req = (ReqInfo) n;
                    BeanMapper.copy(userInfo, req);
                }
            }
        }
        Long startTime = System.currentTimeMillis();

        result = invoker.invoke(invocation);

        takeTime = System.currentTimeMillis() - startTime;

        log.info("dubbo:invocation.getMethodName()  服务运行时间: {}" ,takeTime);
        return result;
    }
}