package com.ohaotian.plugin.uuid.security.entity;

import org.springframework.security.core.GrantedAuthority;


/**
 * 权限信息
 *
 * @author liubq
 */
public class AuthorityInfo implements GrantedAuthority {

    private static final long serialVersionUID = -2567453891993511527L;


    private String key;
    private String tile;

    public AuthorityInfo() {
        super();
    }

    public AuthorityInfo(String key) {
        super();
        this.key = key;
    }

    public AuthorityInfo(String key, String tile) {
        this(key);
        this.tile = tile;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTile() {
        return tile;
    }

    public void setTile(String tile) {
        this.tile = tile;
    }

    @Override
    public String getAuthority() {
        return getKey();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((key == null) ? 0 : key.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AuthorityInfo other = (AuthorityInfo) obj;
        if (key == null) {
            if (other.getKey() != null)
                return false;
        } else if (!key.equals(other.getKey()))
            return false;
        return true;
    }

    @Override
    public String toString() {
        return "AuthorityInfo [key=" + key + ", tile=" + tile + "]";
    }

}
