/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.uuid.security.dubboFilter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.ohaotian.plugin.uuid.base.bo.ReqInfo;
import com.ohaotian.plugin.uuid.base.exception.ZTBusinessException;
import com.ohaotian.plugin.uuid.common.util.BeanMapper;
import com.ohaotian.plugin.uuid.common.util.ValidationUtil;
import com.ohaotian.plugin.uuid.security.entity.UserInfo;
import com.ohaotian.plugin.uuid.security.utils.SecurityHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer"})
public class DubboServiceFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DubboServiceFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) {
        Result result = null;
        Long takeTime = 0L;
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        if (userInfo != null) {
            Object[] arguments;
            for (Object n : arguments = invocation.getArguments()) {
                List validationResults = ValidationUtil.validateModel((Object)n);
                if (validationResults.size() > 0) {
                    StringBuffer msg = new StringBuffer();
                    validationResults.forEach(s -> msg.append(s.getValidationMsg() + "<br/>"));
                    throw new ZTBusinessException(msg.toString());
                }
                if (!(n instanceof ReqInfo) || userInfo == null) continue;
                ReqInfo req = (ReqInfo)n;
                BeanMapper.copy((Object)userInfo, (Object)req);
            }
        }
        Long startTime = System.currentTimeMillis();
        result = invoker.invoke(invocation);
        takeTime = System.currentTimeMillis() - startTime;
        log.info("dubbo:invocation.getMethodName()  \u670d\u52a1\u8fd0\u884c\u65f6\u95f4: {}", (Object)takeTime);
        return result;
    }
}

