/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.uuid.security.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.ohaotian.plugin.uuid.security.jwt.TokenState;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class Jwt {
    private static final Logger logger = LoggerFactory.getLogger(Jwt.class);
    private static byte[] SECRET;
    @Value(value="${app.secret}")
    private String secret;
    private static final JWSHeader header;

    @PostConstruct
    public void init() {
        Assert.notNull((Object)this.secret, (String)"secret is null");
        if (SECRET == null) {
            SECRET = this.secret.getBytes();
        }
    }

    public static void initSecret(String secret) {
        Assert.notNull((Object)secret, (String)"secret is null");
        SECRET = secret.getBytes();
    }

    public static String createToken(Map<String, Object> payload) {
        String tokenString = null;
        JWSObject jwsObject = new JWSObject(header, new Payload(new JSONObject(payload)));
        try {
            jwsObject.sign((JWSSigner)new MACSigner(SECRET));
            tokenString = jwsObject.serialize();
        }
        catch (JOSEException e) {
            logger.error("\u7b7e\u540d\u5931\u8d25:", (Throwable)e);
        }
        return tokenString;
    }

    public static Map<String, Object> validToken(String token) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            JWSObject jwsObject = JWSObject.parse((String)token);
            Payload payload = jwsObject.getPayload();
            MACVerifier verifier = new MACVerifier(SECRET);
            if (jwsObject.verify((JWSVerifier)verifier)) {
                JSONObject jsonOBj = payload.toJSONObject();
                resultMap.put("state", TokenState.VALID.toString());
                if (jsonOBj.containsKey((Object)"ext")) {
                    long extTime = Long.valueOf(jsonOBj.get((Object)"ext").toString());
                    long curTime = System.currentTimeMillis();
                    if (curTime > extTime) {
                        resultMap.clear();
                        resultMap.put("state", TokenState.EXPIRED.toString());
                    }
                }
                resultMap.put("data", jsonOBj);
            } else {
                resultMap.put("state", TokenState.INVALID.toString());
            }
        }
        catch (Exception e) {
            resultMap.clear();
            resultMap.put("state", TokenState.INVALID.toString());
            logger.error("", (Throwable)e);
        }
        return resultMap;
    }

    static {
        header = new JWSHeader(JWSAlgorithm.HS256, JOSEObjectType.JWT, null, null, null, null, null, null, null, null, null, null, null);
    }
}

