/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.uuid.security.service;

import com.ohaotian.plugin.uuid.security.property.FilterStaticConfig;
import com.ohaotian.plugin.uuid.security.utils.RegexUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.stereotype.Component;

@Component
public class CasInvocationSecurityMetadataSourceService
implements FilterInvocationSecurityMetadataSource {
    private static final Logger log = LoggerFactory.getLogger(CasInvocationSecurityMetadataSourceService.class);
    @Autowired
    private FilterStaticConfig filterStaticConfig;

    public Collection<ConfigAttribute> loadResourceDefine(String url) {
        ArrayList<ConfigAttribute> array = new ArrayList<ConfigAttribute>();
        array.add((ConfigAttribute)new SecurityConfig(url));
        return array;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        HttpServletRequest request = ((FilterInvocation)object).getHttpRequest();
        String url = request.getRequestURI();
        url = url.replaceFirst(request.getContextPath(), "");
        log.info(url);
        boolean b = this.wildcardEquals(url);
        if (b) {
            return null;
        }
        return this.loadResourceDefine(url);
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public boolean supports(Class<?> aClass) {
        return true;
    }

    private boolean wildcardEquals(String reqPath) {
        for (String url : this.filterStaticConfig.getResources()) {
            String regex = url;
            String regPath = RegexUtils.getRegPath(regex);
            if (!Pattern.compile(regPath).matcher(reqPath).matches()) continue;
            return true;
        }
        return false;
    }
}

