/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.config;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.CompositeLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class ZTLogoutFilter
extends GenericFilterBean {
    private RequestMatcher logoutRequestMatcher;
    private LogoutHandler handler = null;
    private LogoutSuccessHandler logoutSuccessHandler = null;
    @Value(value="${cas.server.host.outer}")
    private String outerUrl;

    public ZTLogoutFilter(LogoutSuccessHandler logoutSuccessHandler, LogoutHandler ... handlers) {
        this.handler = new CompositeLogoutHandler(handlers);
        Assert.notNull((Object)logoutSuccessHandler, (String)"logoutSuccessHandler cannot be null");
        this.logoutSuccessHandler = logoutSuccessHandler;
        this.setFilterProcessesUrl("/logout");
    }

    public ZTLogoutFilter(String logoutSuccessUrl, LogoutHandler ... handlers) {
        this.handler = new CompositeLogoutHandler(handlers);
        Assert.isTrue((!StringUtils.hasLength((String)logoutSuccessUrl) || UrlUtils.isValidRedirectUrl((String)logoutSuccessUrl) ? 1 : 0) != 0, (String)(logoutSuccessUrl + " isn't a valid redirect URL"));
        SimpleUrlLogoutSuccessHandler urlLogoutSuccessHandler = new SimpleUrlLogoutSuccessHandler();
        if (StringUtils.hasText((String)logoutSuccessUrl)) {
            urlLogoutSuccessHandler.setDefaultTargetUrl(logoutSuccessUrl);
        }
        this.logoutSuccessHandler = urlLogoutSuccessHandler;
        this.setFilterProcessesUrl("/logout");
    }

    public void setLogoutSuccessHandler(String logoutSuccessUrl) {
        Assert.isTrue((!StringUtils.hasLength((String)logoutSuccessUrl) || UrlUtils.isValidRedirectUrl((String)logoutSuccessUrl) ? 1 : 0) != 0, (String)(logoutSuccessUrl + " isn't a valid redirect URL"));
        SimpleUrlLogoutSuccessHandler urlLogoutSuccessHandler = new SimpleUrlLogoutSuccessHandler();
        if (StringUtils.hasText((String)logoutSuccessUrl)) {
            urlLogoutSuccessHandler.setDefaultTargetUrl(logoutSuccessUrl);
        }
        this.logoutSuccessHandler = urlLogoutSuccessHandler;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        StringBuffer sb = request.getRequestURL();
        if (sb.toString().endsWith("/logout")) {
            this.setFilterProcessesUrl(request.getRequestURI());
            String url = sb.toString();
            this.setLogoutSuccessHandler(this.outerUrl + "/logout?service=" + url.substring(0, url.length() - 7));
        }
        if (this.requiresLogout(request, response)) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Logging out user '" + auth + "' and transferring to logout destination"));
            }
            this.handler.logout(request, response, auth);
            this.logoutSuccessHandler.onLogoutSuccess(request, response, auth);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean requiresLogout(HttpServletRequest request, HttpServletResponse response) {
        return this.logoutRequestMatcher.matches(request);
    }

    public void setLogoutRequestMatcher(RequestMatcher logoutRequestMatcher) {
        Assert.notNull((Object)logoutRequestMatcher, (String)"logoutRequestMatcher cannot be null");
        this.logoutRequestMatcher = logoutRequestMatcher;
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.logoutRequestMatcher = new AntPathRequestMatcher(filterProcessesUrl);
    }
}

