/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.config;

import java.io.IOException;
import java.lang.reflect.Field;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.stereotype.Component;

@Component
public class CrownAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrownAuthenticationSuccessHandler.class);

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        LOGGER.debug("url===" + request.getRequestURL());
        LOGGER.debug("step 1: scheme = " + request.getScheme());
        HttpSession session = request.getSession(false);
        DefaultSavedRequest saveRequest = null;
        if (session != null) {
            LOGGER.debug("session is not null !!");
            saveRequest = (DefaultSavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        }
        try {
            if (saveRequest == null) {
                LOGGER.debug("step 2: saveRequest is null ");
                HttpSessionRequestCache requestCache = new HttpSessionRequestCache();
                requestCache.saveRequest(request, response);
                saveRequest = (DefaultSavedRequest)requestCache.getRequest(request, response);
                Field contextPathField = DefaultSavedRequest.class.getDeclaredField("contextPath");
                contextPathField.setAccessible(true);
                Field uriField = DefaultSavedRequest.class.getDeclaredField("requestURI");
                uriField.setAccessible(true);
                uriField.set(saveRequest, contextPathField.get(saveRequest) + "/index.html#/");
                LOGGER.debug("step 4: saveRequest.uriField is " + uriField.get(saveRequest));
                Field queryStringField = DefaultSavedRequest.class.getDeclaredField("queryString");
                queryStringField.setAccessible(true);
                queryStringField.set(saveRequest, null);
            }
            if ("http".equalsIgnoreCase(request.getScheme())) {
                LOGGER.debug("step 2: saveRequest.getRequestURL is " + saveRequest.getRequestURL());
                Field schemeField = DefaultSavedRequest.class.getDeclaredField("scheme");
                schemeField.setAccessible(true);
                String fieldValue = (String)schemeField.get(saveRequest);
                LOGGER.debug("2 scheme before: " + fieldValue);
                schemeField.setAccessible(true);
                schemeField.set(saveRequest, "https");
                String fieldValue1 = (String)schemeField.get(saveRequest);
                LOGGER.debug("fieldValue = " + fieldValue1);
                Field portStringField = DefaultSavedRequest.class.getDeclaredField("serverPort");
                portStringField.setAccessible(true);
                portStringField.set(saveRequest, 443);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onAuthenticationSuccess(request, response, authentication);
    }
}

