/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.jwt.Jwt;
import com.ohaotian.plugin.security.jwt.TokenState;
import com.ohaotian.plugin.security.service.GetUserInfoByUserIdService;
import com.ohaotian.plugin.security.service.LoginService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.filter.GenericFilterBean;

public class TokenAuthenticationFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAuthenticationFilter.class);
    private static ThreadLocal<Boolean> allowSessionCreation = new ThreadLocal();
    private GetUserInfoByUserIdService getUserInfoByTokenService;
    private LoginService loginService;

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        String token = request.getHeader("auth-token");
        if ("123".equals(token)) {
            UserInfo user = new UserInfo();
            return new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
        }
        long extTime = this.loginService.getLoginExpTime(token);
        LOGGER.info("\u5230\u671f\u65f6\u95f4" + extTime);
        Map<String, Object> resultMap = Jwt.validToken(token, extTime);
        TokenState state = TokenState.getTokenState((String)resultMap.get("state"));
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        switch (state) {
            case VALID: {
                JSONObject data = (JSONObject)resultMap.get("data");
                request.setAttribute("data", (Object)data);
                String appCode = data.getAsString("appCode");
                this.loginService.updateLoginExpTime((Long)data.get((Object)"userId"), token, appCode);
                UserDetails user = this.getUserInfoByTokenService != null ? this.getUserInfoByTokenService.getUserInfoByUserId((Long)data.get((Object)"userId"), token, appCode) : (UserDetails)data.get((Object)"userInfo");
                return new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
            }
            case EXPIRED: {
                jsonObject.put("MESSAGE", (Object)"Token \u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u7533\u8bf7 token");
                break;
            }
            default: {
                jsonObject.put("MESSAGE", (Object)"Token \u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u7533\u8bf7 token");
            }
        }
        response.setStatus(401);
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        jsonObject.put("code", (Object)"1");
        String jsonString = JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        out.write(jsonString);
        out.close();
        return null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        allowSessionCreation.set(true);
        if (request.getHeader("auth-token") != null) {
            Authentication auth = this.attemptAuthentication(request, response);
            if (auth == null) {
                return;
            }
            allowSessionCreation.set(false);
            SecurityContextHolder.getContext().setAuthentication(auth);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static boolean isAllowSessionCreation() {
        return allowSessionCreation.get();
    }

    public GetUserInfoByUserIdService getGetUserInfoByTokenService() {
        return this.getUserInfoByTokenService;
    }

    public void setGetUserInfoByTokenService(GetUserInfoByUserIdService getUserInfoByTokenService) {
        this.getUserInfoByTokenService = getUserInfoByTokenService;
    }
}

