/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.filter;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.security.filter.SingleSignOutHandler;
import com.ohaotian.plugin.security.property.AppServerConfig;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import com.ohaotian.plugin.session.CacheSessionRepository;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.util.AbstractConfigurationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class SingleSignOutFilter
extends AbstractConfigurationFilter {
    private static final Logger logger = LoggerFactory.getLogger(SingleSignOutFilter.class);
    @Resource
    private AppServerConfig appServerConfig;
    @Resource
    CacheClient cacheClient;
    @Value(value="${session.timeout:120}")
    private int timeOut;
    @Resource
    private CacheSessionRepository cacheSessionRepository;
    private static final SingleSignOutHandler handler = new SingleSignOutHandler();

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.info("\u521d\u59cb\u5316======");
        if (!this.isIgnoreInitConfiguration()) {
            if (StringUtils.isNotBlank((CharSequence)filterConfig.getInitParameter("artifactParameterName"))) {
                handler.setArtifactParameterName(filterConfig.getInitParameter("artifactParameterName"));
            } else {
                handler.setArtifactParameterName("ticket");
            }
            if (StringUtils.isNotBlank((CharSequence)filterConfig.getInitParameter("logoutParameterName"))) {
                handler.setLogoutParameterName(filterConfig.getInitParameter("logoutParameterName"));
            } else {
                handler.setLogoutParameterName("logoutRequest");
            }
        }
        logger.info("\u521d\u59cb\u5316clusterNodeUrls=" + this.appServerConfig.getClusterNodeUrls());
        if (StringUtils.isNotBlank((CharSequence)this.appServerConfig.getClusterNodeUrls())) {
            handler.setClusterNodeUrls(this.appServerConfig.getClusterNodeUrls());
        }
        handler.init();
    }

    public void setArtifactParameterName(String name) {
        handler.setArtifactParameterName(name);
    }

    public void setLogoutParameterName(String name) {
        handler.setLogoutParameterName(name);
    }

    public void setSessionMappingStorage(SessionMappingStorage storage) {
        handler.setSessionMappingStorage(storage);
    }

    public void setClusterNodeUrls(String clusterNodeUrls) {
        handler.setClusterNodeUrls(clusterNodeUrls);
    }

    public void setCasServerUrlPrefix(String casServerUrlPrefix) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (handler.isTokenRequest(request)) {
            long startTime = System.currentTimeMillis();
            logger.info("handler.isTokenRequest");
            logger.info("\u83b7\u53d6ticket");
            logger.info("timeOut" + this.timeOut);
            handler.recordSession(request, this.cacheClient, this.timeOut);
            logger.info("\u83b7\u53d6ticket\u7ed3\u675f\uff0c\u7528\u65f6\uff1a" + (System.currentTimeMillis() - startTime));
        } else {
            if (handler.isLogoutRequest(request)) {
                logger.info("handler.isLogoutRequest");
                if (null != SecurityHelper.getCurrentUser()) {
                    logger.info("\u7528\u6237ID\uff1a" + SecurityHelper.getCurrentUser().getUserId());
                }
                String sessionId = request.getSession().getId();
                logger.info("\u6e05\u9664session=" + sessionId);
                handler.destroySession(request, this.cacheClient, this.cacheSessionRepository);
                this.cacheClient.delete("ZT-SESSIONID:" + sessionId);
                logger.info("\u6e05\u9664session=" + sessionId + "\u5b8c\u6210");
                return;
            }
            if (handler.isLogoutRequestFromClusterNode(request)) {
                logger.info("handler.isLogoutRequestFromClusterNode");
                if (null != SecurityHelper.getCurrentUser()) {
                    logger.info("\u7528\u6237ID\uff1a" + SecurityHelper.getCurrentUser().getUserId());
                }
                handler.destroySessionFromClusterNode(request, this.cacheClient, this.cacheSessionRepository);
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    protected static SingleSignOutHandler getSingleSignOutHandler() {
        return handler;
    }
}

