/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.service.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.security.service.LoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class LoginServiceImpl
implements LoginService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginServiceImpl.class);
    public static String LOGIN_EXP_TIME = "LoginExpTime";
    @Autowired
    private CacheClient cacheService;
    @Value(value="${login.expTime:7200}")
    private int expTime;
    @Value(value="${login.refreshTime:10}")
    private int refreshTime;
    @Value(value="${login.uniqueLoginFlag:false}")
    private Boolean uniqueLoginFlag;

    @Override
    public long getLoginExpTime(String token) {
        long rspExt = (Long)this.cacheService.get(token + LOGIN_EXP_TIME);
        return rspExt;
    }

    @Override
    public void updateLoginExpTime(Long userId, String token, String appCode) {
        LOGGER.debug("\u5230\u671f\u65f6\u95f4{},\u65b0\u5230\u671f\u65f6\u95f4{}", (Object)this.expTime);
        Long newExpTime = System.currentTimeMillis() + (long)(this.expTime * 1000);
        Long expDate = (Long)this.cacheService.get(token + LOGIN_EXP_TIME);
        if (expDate == null) {
            expDate = 0L;
        }
        LOGGER.debug("\u5230\u671f\u65f6\u95f4{},\u65b0\u5230\u671f\u65f6\u95f4{}", (Object)expDate, (Object)newExpTime);
        long diff = (newExpTime - expDate) / 1000L / 60L;
        if (diff > (long)this.refreshTime) {
            this.cacheService.set(token + LOGIN_EXP_TIME, (Object)newExpTime, this.expTime);
            if (this.uniqueLoginFlag.booleanValue()) {
                String uniqueLoginStr = "UniqueLogin_" + appCode + "_" + userId;
                this.cacheService.set(uniqueLoginStr, (Object)token, this.expTime);
            }
        }
    }

    @Override
    public void logOut(String token) {
        this.cacheService.delete(token + LOGIN_EXP_TIME);
    }

    @Override
    public void uniqueLogin(Long userId, String token, String appCode) {
        if (userId != null && this.uniqueLoginFlag.booleanValue()) {
            String uniqueLoginStr = "UniqueLogin_" + appCode + "_" + userId;
            String tokenGet = (String)this.cacheService.get(uniqueLoginStr);
            if (!StringUtils.isEmpty((Object)tokenGet) && !token.equals(token)) {
                this.cacheService.delete(token + LOGIN_EXP_TIME);
            }
            this.cacheService.set(uniqueLoginStr, (Object)token, this.expTime);
        }
    }
}

