/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.filter;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.session.CacheSessionRepository;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.jasig.cas.client.session.HashMapBackedSessionMappingStorage;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.XmlUtils;

public final class SingleSignOutHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private SessionMappingStorage sessionMappingStorage = new HashMapBackedSessionMappingStorage();
    private String artifactParameterName = "ticket";
    private String logoutParameterName = "logoutRequest";
    private String logoutParameterClusterName = "logoutRequestCluster";
    private String clusterNodeUrls;

    public void setSessionMappingStorage(SessionMappingStorage storage) {
        this.sessionMappingStorage = storage;
    }

    public SessionMappingStorage getSessionMappingStorage() {
        return this.sessionMappingStorage;
    }

    public void setArtifactParameterName(String name) {
        this.artifactParameterName = name;
    }

    public void setLogoutParameterName(String name) {
        this.logoutParameterName = name;
    }

    public void setClusterNodeUrls(String clusterNodeUrls) {
        this.clusterNodeUrls = clusterNodeUrls;
    }

    public void init() {
        CommonUtils.assertNotNull((Object)this.artifactParameterName, (String)"artifactParameterName cannot be null.");
        CommonUtils.assertNotNull((Object)this.logoutParameterName, (String)"logoutParameterName cannot be null.");
        CommonUtils.assertNotNull((Object)this.sessionMappingStorage, (String)"sessionMappingStorage cannote be null.");
    }

    public boolean isTokenRequest(HttpServletRequest request) {
        return CommonUtils.isNotBlank((String)CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.artifactParameterName));
    }

    public boolean isLogoutRequest(HttpServletRequest request) {
        return "POST".equals(request.getMethod()) && !this.isMultipartRequest(request) && CommonUtils.isNotBlank((String)CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.logoutParameterName));
    }

    public boolean isLogoutRequestFromClusterNode(HttpServletRequest request) {
        return !this.isMultipartRequest(request) && "true".equals(request.getParameter(this.logoutParameterClusterName));
    }

    public String recordSession(HttpServletRequest request, CacheClient cacheClient, int timeOut) {
        HttpSession session = request.getSession(true);
        session.setMaxInactiveInterval(timeOut * 60);
        String token = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.artifactParameterName);
        this.log.info((Object)("--------recordSession-------------token:" + token));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Recording session for token " + token));
        }
        try {
            this.sessionMappingStorage.removeBySessionById(session.getId());
        }
        catch (Exception e) {
            this.log.error((Object)("removeBySessionById failure\uff1a" + e.getMessage()));
        }
        this.sessionMappingStorage.addSessionById(token, session);
        this.log.info((Object)("savatocache token\uff1a" + token + " sessionId\uff1a" + session.getId() + "expire" + timeOut * 60));
        cacheClient.set(token, (Object)session.getId(), timeOut * 60);
        return session.getId();
    }

    public void destroySession(HttpServletRequest request, CacheClient cacheClient, CacheSessionRepository cacheSessionRepository) {
        this.log.debug((Object)"destroySession begin---");
        String logoutMessage = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.logoutParameterName);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Logout request:\n" + logoutMessage));
        }
        String token = null;
        if (null != logoutMessage) {
            token = XmlUtils.getTextForElement((String)logoutMessage, (String)"SessionIndex");
        }
        this.log.info((Object)("destroySession session\u5728\u5f53\u524d\u8282\u70b9\u4e0btoken------" + token));
        if (CommonUtils.isNotBlank((String)token)) {
            HttpSession session;
            Object sessionId = cacheClient.get(token);
            if (null != sessionId) {
                this.log.info((Object)("destroySession \u6e05\u9664redis session\uff1a" + sessionId));
                cacheSessionRepository.delete(sessionId.toString());
            }
            if ((session = this.sessionMappingStorage.removeSessionByMappingId(token)) != null) {
                this.log.info((Object)"destroySession session\u5728\u5f53\u524d\u8282\u70b9------");
                String sessionID = session.getId();
                this.log.info((Object)("destroySession session\u5728\u5f53\u524d\u8282\u70b9\u4e0bsessionId------" + sessionID));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Invalidating session [" + sessionID + "] for token [" + token + "]"));
                }
                try {
                    session.invalidate();
                }
                catch (IllegalStateException e) {
                    this.log.error((Object)"Error invalidating session.", (Throwable)e);
                }
            } else {
                this.log.info((Object)"destroySession session\u4e0d\u5728\u5f53\u524d\u8282\u70b9------");
                this.destroySessionOfClusterNodes(token);
            }
        }
        this.log.debug((Object)"destroySession end---");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroySessionOfClusterNodes(String token) {
        this.log.info((Object)("destroySessionOfClusterNodes--begin-----:" + token + ",clusterNodeUrls=" + this.clusterNodeUrls));
        if (this.clusterNodeUrls != null && this.clusterNodeUrls.length() > 0) {
            String[] clusters;
            this.log.debug((Object)this.clusterNodeUrls);
            for (String url : clusters = this.clusterNodeUrls.split(",")) {
                DefaultHttpClient httpClient = new DefaultHttpClient();
                HttpPost httpPostReq = new HttpPost(url);
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                paramList.add(new BasicNameValuePair(this.logoutParameterClusterName, "true"));
                paramList.add(new BasicNameValuePair(this.artifactParameterName, token));
                try {
                    httpPostReq.setEntity((HttpEntity)new UrlEncodedFormEntity(paramList));
                    httpClient.execute((HttpUriRequest)httpPostReq);
                }
                catch (Exception e) {
                    this.log.error((Object)"Error destroySessionOfClusterNodes.", (Throwable)e);
                }
                finally {
                    HttpClientUtils.closeQuietly((HttpClient)httpClient);
                }
            }
        }
        this.log.info((Object)("destroySessionOfClusterNodes--end-----:" + token));
    }

    public void destroySessionFromClusterNode(HttpServletRequest request, CacheClient cacheClient, CacheSessionRepository cacheSessionRepository) {
        String token = request.getParameter(this.artifactParameterName);
        this.log.info((Object)("destroySessionFromClusterNode----begin---:" + token));
        if (CommonUtils.isNotBlank((String)token)) {
            HttpSession session;
            Object sessionId = cacheClient.get(token);
            if (null != sessionId) {
                this.log.info((Object)("destroySessionFromClusterNode \u6e05\u9664redis session\uff1a" + sessionId));
                cacheSessionRepository.delete(sessionId.toString());
            }
            if ((session = this.sessionMappingStorage.removeSessionByMappingId(token)) != null) {
                String sessionID = session.getId();
                this.log.info((Object)("destroySessionFromClusterNode\u4ece\u5176\u5b83\u8282\u70b9\u4e0bsessionId------" + sessionID));
                if (this.log.isDebugEnabled()) {
                    this.log.info((Object)("Invalidating session[" + sessionID + "] for token [" + token + "]"));
                }
                try {
                    session.invalidate();
                    cacheClient.delete("ZT-SESSIONID:" + sessionID);
                    this.log.info((Object)("\u6e05\u9664session=" + sessionID + "\u5b8c\u6210"));
                }
                catch (IllegalStateException e) {
                    this.log.error((Object)"Error invalidating session", (Throwable)e);
                }
                catch (Exception e1) {
                    this.log.error((Object)"Error", (Throwable)e1);
                }
            }
        }
        this.log.info((Object)("destroySessionFromClusterNode----end---:" + token));
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().toLowerCase().startsWith("multipart");
    }
}

