package com.ohaotian.plugin.session;

import org.springframework.session.Session;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
public class CacheSession implements Session, Serializable {

    private static final long serialVersionUID = 3024506719282139459L;
    /**
     * session id
     */
    private String id;
    /**
     * 属性
     */
    private Map<String, Object> attributes;
    /**
     * 创建时间
     */
    private Instant creationTime;
    /**
     * 上一次操作时间
     */
    private Instant lastAccessedTime;

    private boolean isNew;


    public CacheSession() {
        this("ZT-" + UUID.randomUUID().toString());
    }

    public CacheSession(String id) {
        this.id = id;
        this.attributes = new HashMap();
        this.creationTime = Instant.now();
        this.lastAccessedTime = this.creationTime;
        this.isNew = true;
    }

    public CacheSession(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("session cannot be null");
        }
        this.id = session.getId();
        this.attributes = new HashMap(session.getAttributeNames().size());
        session.getAttributeNames().forEach(attrName -> {
            Object attrValue = session.getAttribute(attrName);
            this.attributes.put(attrName, attrValue);
        });
        this.lastAccessedTime = Instant.now();
        this.creationTime = Instant.now();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String changeSessionId() {
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Instant getCreationTime() {
        return creationTime;
    }

    @Override
    public void setLastAccessedTime(Instant instant) {

    }

    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public Instant getLastAccessedTime() {
        return lastAccessedTime;
    }

    @Override
    public void setMaxInactiveInterval(Duration duration) {

    }

    @Override
    public Duration getMaxInactiveInterval() {
        return null;
    }


    @Override
    public boolean isExpired() {
        return false;
    }

    public Map<String, Object> getAttributes() {
        return attributes;
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    @Override
    public <T> T getAttribute(String attributeName) {
        return (T) attributes.get(attributeName);
    }

    @Override
    public <T> T getRequiredAttribute(String name) {
        return null;
    }

    @Override
    public <T> T getAttributeOrDefault(String name, T defaultValue) {
        return null;
    }

    @Override
    public void removeAttribute(String attributeName) {
        this.attributes.remove(attributeName);
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) {
        if (attributeValue == null) {
            removeAttribute(attributeName);
        } else {
            this.attributes.put(attributeName, attributeValue);
        }
        this.isNew = true;
    }



    public boolean isNew() {
        return isNew;
    }

    public void setNew(boolean aNew) {
        isNew = aNew;
    }
}
