package com.ohaotian.plugin.constant;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SessionConstant {

    @Value("${session.timeout:30}")
    private Integer defaultMaxInactiveIntervalReids;

    @Value("${session.max.size:1000}")
    private Long caffeineSize;

    public Integer getDefaultMaxInactiveIntervalReids() {
        return defaultMaxInactiveIntervalReids * 60;
    }


    public Long getDefaultMaxInactiveIntervalCaffeine() {
        return defaultMaxInactiveIntervalReids * 60 * 2 / 3L;
    }

    public Long getCaffeineSize() {
        return caffeineSize;
    }

    public void setCaffeineSize(Long caffeineSize) {
        this.caffeineSize = caffeineSize;
    }
}
