package com.ohaotian.plugin.test;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class RemoveHsfBeansPostProcessor implements BeanFactoryPostProcessor, ApplicationContextAware {

    private static final String HSF_NAME = "com.taobao.hsf.app.spring.util.HSFSpringProviderBean";

    private ApplicationContext applicationContext;

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {

        BeanDefinitionRegistry beanDefinitionRegistry = null;

        if (applicationContext instanceof GenericApplicationContext) {
            beanDefinitionRegistry = ((DefaultListableBeanFactory) ((GenericApplicationContext) applicationContext).getBeanFactory());
        } else if (applicationContext instanceof ClassPathXmlApplicationContext) {
            beanDefinitionRegistry = ((DefaultListableBeanFactory) ((ClassPathXmlApplicationContext) applicationContext).getBeanFactory());
        }

        if (beanDefinitionRegistry != null) {
            String[] beanDefinitionNames = beanDefinitionRegistry.getBeanDefinitionNames();
            for (String name : beanDefinitionNames) {
                BeanDefinition beanDefinition = beanDefinitionRegistry.getBeanDefinition(name);
                if (beanDefinition.getBeanClassName() != null && beanDefinition.getBeanClassName().equals(HSF_NAME)) {
                    beanDefinitionRegistry.removeBeanDefinition(name);
                }
            }
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
