package com.ohaotian.plugin.validation.internal.constraintvalidators;

import com.ohaotian.plugin.validation.constraints.CheckCase;
import com.ohaotian.plugin.validation.enums.CaseMode;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <hr>
 *
 * @author TheWk
 * @version 1.0.0
 * <pre>
 * =========================== Logs =========================== <br>
 * 1.0.0(2018-03-08 17:38) TheWk 创建 <br>
 * =========================== Logs =========================== <br>
 * </pre>
 */
public class CheckCaseValidator implements ConstraintValidator<CheckCase, CharSequence> {

    private CaseMode caseMode;

    @Override
    public void initialize(CheckCase checkCase) {
        caseMode = checkCase.value();
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }

        if (caseMode == CaseMode.UPPER) {
            return value.equals(String.valueOf(value).toUpperCase());
        } else {
            return value.equals(String.valueOf(value).toLowerCase());
        }
    }
}
