package com.ohaotian.plugin.validation.internal.constraintvalidators;

import com.ohaotian.plugin.validation.constraints.StartsWith;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author TheWk
 * @version 1.0.0
 * <pre>
 * =========================== Logs =========================== <br>
 * 1.0.0(2017-10-30 15:33) TheWk 创建 <br>
 * =========================== Logs =========================== <br>
 * </pre>
 */
public class StartsWithValidator implements ConstraintValidator<StartsWith, CharSequence> {

    private String starts;

    @Override
    public void initialize(StartsWith constraintAnnotation) {
        this.starts = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null || value.length() == 0) {
            return true;
        }
        return value.toString().startsWith(starts);
    }
}
