package com.ohaotian.plugin.validation.constraints;

import com.ohaotian.plugin.validation.constant.ValidationConstant;

import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import javax.validation.constraints.Pattern;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * 消息提示: {com.ohaotian.base.validation.constraints.Age.message}
 * <p>
 * 国际化提示: 请输入有效的年龄
 *
 * @author TheWk
 * @version 1.0.0
 * <pre>
 * =========================== Logs =========================== <br>
 * 1.0.0(2018-03-07 17:00) TheWk 创建 <br>
 * =========================== Logs =========================== <br>
 * </pre>
 */
@Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
@Retention(RUNTIME)
@Documented
@Constraint(validatedBy = {})
@ReportAsSingleViolation
@Pattern(regexp = ValidationConstant.AGE)
public @interface Age {

    String message() default "{com.ohaotian.base.validation.constraints.Age.message}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    /**
     * Defines several {@link Age} annotations on the same element.
     *
     * @see Age
     */
    @Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
    @Retention(RUNTIME)
    @Documented
    @interface List {

        Age[] value();
    }
}
